/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.URLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class OutputURLListParameter
extends URLListParameter {
    public static final String TYPE_VALUE = "OUTPUT_URL";

    public OutputURLListParameter(String name, String label, String description, List<FileURLValue> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String localization, String[] fileTypes, FileParameterMode mode, boolean mustSort, EnumSet<URLProtocol> allowedProtocols) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, localization, fileTypes, mode, mustSort, false, allowedProtocols);
        if (fileTypes != null && fileTypes.length > 1) {
            String errorMessage = "Par\u00e2metro n\u00e3o aceita m\u00faltiplos tipos de arquivo associados.";
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public String getType() {
        return TYPE_VALUE;
    }

    @Override
    public String getValueAsJSON() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.getValue() != null) {
            for (FileURLValue file : (List)this.getValue()) {
                values.add(file.getPath());
            }
        }
        return this.objectToJSON(values);
    }

    @Override
    public void setJSONValue(Object value) {
        if (value == null) {
            this.setValue(null);
            return;
        }
        List list = (List)value;
        list.forEach(i -> this.addElement(FileURLValue.getURLFromString(this.getMode(), (String)i)));
    }
}

