/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TextParameterListener;
import csbase.logic.algorithms.parameters.validators.TextParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public final class TextParameter
extends SimpleParameter<String> {
    public static final String TYPE = "TEXT";
    private boolean isEditable;
    private transient List<TextParameterListener> listeners = new LinkedList<TextParameterListener>();
    private Integer maxCharacters;

    public TextParameter(String name, String label, String description, String defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, Integer maxCharacters) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        this.setMaxCharacters(maxCharacters);
        this.setEditable(true);
    }

    public void addTextParameterListener(TextParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        this.listeners.add(listener);
    }

    @Override
    public Object getExpressionValue() {
        return null;
    }

    public Integer getMaxCharacters() {
        return this.maxCharacters;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        if (this.isEditable != isEditable) {
            this.isEditable = isEditable;
            for (TextParameterListener listener : this.listeners) {
                listener.editabilityWasChanged(this);
            }
        }
    }

    @Override
    public void setValueAsText(String parameterValue) {
        this.setValue(parameterValue);
    }

    private void setMaxCharacters(Integer maxCharacters) {
        if (maxCharacters != null && maxCharacters <= 0) {
            throw new IllegalArgumentException(String.format(LNG.get((String)"csbase.logic.algorithms.positiveParameter"), "maxCharacters", maxCharacters.toString()));
        }
        this.maxCharacters = maxCharacters;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<TextParameterListener>();
    }

    public TextParameterValidator createParameterValidator() {
        return new TextParameterValidator(this.isOptional(), this.getMaxCharacters());
    }

    @Override
    public void setJSONValue(Object value) {
        if (value == null) {
            this.setValue(null);
            return;
        }
        this.setValue((String)value);
    }
}

