/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.DoubleStructureAttributes;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;

public class DoubleListParameterFactory
extends SimpleParameterParser<DoubleListParameter>
implements DoubleStructureAttributes {
    public static final String DOUBLE_LIST_PARAMETER_ELEMENT = "lista_de_reais";

    @Override
    public DoubleListParameter createSimpleParameter(XmlParser parser, ParsedSimpleParameter definition, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Double maximum = (Double)definition.getAttributeValue("maximo");
        boolean isMaximumIncluded = (Boolean)definition.getAttributeValue("incluir_maximo");
        Double minimum = (Double)definition.getAttributeValue("minimo");
        boolean isMinimumIncluded = (Boolean)definition.getAttributeValue("incluir_minimo");
        return new DoubleListParameter(definition.getName(), definition.getLabel(), definition.getDescription(), null, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), maximum, isMaximumIncluded, minimum, isMinimumIncluded);
    }

    @Override
    public ParameterStructure<DoubleListParameter> getParameterStructure() {
        return this.getDoubleStructure(DOUBLE_LIST_PARAMETER_ELEMENT, DoubleListParameter.class);
    }
}

