/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringAttribute;

public class BooleanParameterFactory
extends SimpleParameterParser<BooleanParameter> {
    public static final String BOOLEAN_PARAMETER_ELEMENT = "booleano";
    public static final String BOOLEAN_ELEMENT_FALSE_ATTRIBUTE = "falso";
    public static final String BOOLEAN_ELEMENT_TRUE_ATTRIBUTE = "verdadeiro";

    @Override
    public BooleanParameter createSimpleParameter(XmlParser parser, ParsedSimpleParameter definition, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        boolean defaultValue = (Boolean)definition.getAttributeValue("padrao");
        String falseCommand = (String)definition.getAttributeValue(BOOLEAN_ELEMENT_FALSE_ATTRIBUTE);
        String trueCommand = (String)definition.getAttributeValue(BOOLEAN_ELEMENT_TRUE_ATTRIBUTE);
        return new BooleanParameter(definition.getName(), definition.getLabel(), definition.getDescription(), defaultValue, definition.isVisible(), definition.getCommandLinePattern(), falseCommand, trueCommand);
    }

    @Override
    public ParameterStructure<BooleanParameter> getParameterStructure() {
        SimpleParameterStructure<BooleanParameter> structure = new SimpleParameterStructure<BooleanParameter>(BOOLEAN_PARAMETER_ELEMENT, BooleanParameter.class);
        structure.addAttribute(new StringAttribute(BOOLEAN_ELEMENT_TRUE_ATTRIBUTE, null));
        structure.addAttribute(new StringAttribute(BOOLEAN_ELEMENT_FALSE_ATTRIBUTE, null));
        structure.addAttribute(new BooleanAttribute("padrao", false));
        return structure;
    }
}

