/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleListParameterListener;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.validators.DoubleParameterValidator;
import csbase.logic.algorithms.parameters.validators.ListParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public final class DoubleListParameter
extends ListParameter<Double> {
    public static final String TYPE = "LIST_OF_DOUBLES";
    private boolean isMaximumIncluded;
    private boolean isMinimumIncluded;
    private Double maximum;
    private Double minimum;
    private transient List<DoubleListParameterListener> listeners = new LinkedList<DoubleListParameterListener>();

    public DoubleListParameter(String name, String label, String description, List<Double> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, Double maximum, boolean includeMaximum, Double minimum, boolean includeMinimum) {
        super(name, label, description, defaultValue, isOptional, isVisible, false, true, commandLinePattern);
        this.setMaximum(maximum, includeMaximum);
        this.setMinimum(minimum, includeMinimum);
    }

    public void addDoubleListParameterListener(DoubleListParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        this.listeners.add(listener);
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean isMaximumIncluded() {
        return this.isMaximumIncluded;
    }

    public boolean isMinimumIncluded() {
        return this.isMinimumIncluded;
    }

    public boolean setMaximum(Double maximum, boolean maximumIncluded) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MaxLessThanMin"));
        }
        boolean maxIncluded = maximumIncluded;
        if (maximum == null) {
            if (this.maximum == null) {
                return false;
            }
            maxIncluded = false;
        } else if (maximum.equals(this.maximum)) {
            return false;
        }
        this.isMaximumIncluded = maxIncluded;
        this.maximum = maximum;
        this.updateValidator();
        for (DoubleListParameterListener listener : this.listeners) {
            listener.maximumWasChanged(this);
        }
        return true;
    }

    public boolean setMinimum(Double minimum, boolean minimumIncluded) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MinGreaterThenMax"));
        }
        boolean minIncluded = minimumIncluded;
        if (minimum == null) {
            if (this.minimum == null) {
                return false;
            }
            minIncluded = false;
        } else if (minimum.equals(this.minimum)) {
            return false;
        }
        this.isMinimumIncluded = minIncluded;
        this.minimum = minimum;
        this.updateValidator();
        for (DoubleListParameterListener listener : this.listeners) {
            listener.minimumWasChanged(this);
        }
        return true;
    }

    private void updateValidator() {
        ListParameterValidator listParameterValidator = (ListParameterValidator)this.getParameterValidator();
        DoubleParameterValidator validator = (DoubleParameterValidator)listParameterValidator.getItemValidator();
        validator.setMaximum(this.maximum, this.isMaximumIncluded);
        validator.setMinimum(this.minimum, this.isMinimumIncluded);
    }

    @Override
    public Double getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            return null;
        }
        try {
            double doubleValue = Double.parseDouble(itemValue);
            return new Double(doubleValue);
        }
        catch (NumberFormatException e) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidDoubleParameter"), itemValue, this);
        }
    }

    protected DoubleParameterValidator createItemValidator() {
        return new DoubleParameterValidator(this.isOptional(), this.maximum, this.isMaximumIncluded, this.minimum, this.isMinimumIncluded);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<DoubleListParameterListener>();
    }

    @Override
    public void setJSONValue(Object value) {
        if (value == null) {
            this.setValue(null);
            return;
        }
        List list = (List)value;
        list.forEach(i -> {
            if (i instanceof Double) {
                this.addElement((Double)i);
            } else if (i != null) {
                this.addElement(Double.valueOf(i.toString()));
            }
        });
    }
}

