/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.serializer;

import csbase.exception.ConfigurationException;
import csbase.exception.ParseException;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.FlowAlgorithmParser;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.serializer.IAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerIOException;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerParseException;
import csbase.remote.ClientRemoteLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import tecgraf.javautils.core.lng.LNG;

public final class FlowAlgorithmConfigurationSerializer
implements IAlgorithmConfigurationSerializer {
    @Override
    public AlgorithmConfigurator read(InputStream input) throws AlgorithmConfigurationSerializerParseException, AlgorithmConfigurationSerializerIOException, AlgorithmConfigurationSerializerException, AlgorithmNotFoundException {
        try {
            FlowAlgorithmParser.PersistedFlowWrapper flowWrapper = new FlowAlgorithmParser().readFromPersistence(input);
            AlgorithmVersionInfo algoVersionInfo = null;
            if (flowWrapper.algorithmId != null && flowWrapper.algorithmVersion != null) {
                AlgorithmVersionId algorithmVersionId = AlgorithmVersionId.create(flowWrapper.algorithmVersion);
                AlgorithmInfo info = ClientRemoteLocator.algorithmService.getInfo(flowWrapper.algorithmId);
                algoVersionInfo = info.getVersionInfo(algorithmVersionId);
            }
            if (algoVersionInfo != null) {
                return new FlowAlgorithmConfigurator(algoVersionInfo, flowWrapper.flow);
            }
            return new FlowAlgorithmConfigurator(flowWrapper.flow);
        }
        catch (ConfigurationException e) {
            throw new AlgorithmConfigurationSerializerException(e);
        }
        catch (ParseException e) {
            throw new AlgorithmConfigurationSerializerParseException(e);
        }
        catch (IOException e) {
            throw new AlgorithmConfigurationSerializerIOException(e);
        }
    }

    @Override
    public void write(AlgorithmConfigurator configurator, OutputStream output) throws AlgorithmConfigurationSerializerException {
        if (configurator.getConfiguratorType() != AlgorithmConfigurator.ConfiguratorType.FLOW) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.serializer.SerialConfiguratorType"));
        }
        FlowAlgorithmConfigurator flowConfigurator = (FlowAlgorithmConfigurator)configurator;
        try {
            String algorithmId = null;
            String algorithmVersion = null;
            if (flowConfigurator.getAlgorithmVersion() != null) {
                algorithmId = flowConfigurator.getAlgorithmId();
                algorithmVersion = flowConfigurator.getAlgorithmVersionId().toString();
            }
            new FlowAlgorithmParser().writeToPersistence(output, flowConfigurator.getFlow(), algorithmId, algorithmVersion);
        }
        catch (Exception e) {
            throw new AlgorithmConfigurationSerializerException(e);
        }
    }
}

