/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.CommonProjectInfo;
import csbase.logic.User;
import java.util.HashSet;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public class ProjectPermissions {
    private static final String SHARING_TYPE = "SHARING_TYPE";
    private static final String USERS_RO = "USERS_RO";
    private static final String USERS_RW = "USERS_RW";
    private static final SharingType[] SHARING_TYPE_CONSTANTS = SharingType.values();

    public static SharingType getSharingType(CommonProjectInfo prjInfo) {
        Integer typeOrdinal = (Integer)prjInfo.getAttribute(SHARING_TYPE);
        if (typeOrdinal == null) {
            throw new IllegalStateException(LNG.get((String)"csbase.logic.OldSharingType"));
        }
        return SHARING_TYPE_CONSTANTS[typeOrdinal];
    }

    public static void setSharingType(CommonProjectInfo prjInfo, SharingType type) {
        prjInfo.setAttribute(SHARING_TYPE, type.ordinal());
    }

    public static Set<Object> getUsersRO(CommonProjectInfo prjInfo) {
        return ProjectPermissions.getUsers(prjInfo, true);
    }

    public static Set<Object> getUsersRW(CommonProjectInfo prjInfo) {
        return ProjectPermissions.getUsers(prjInfo, false);
    }

    public static Set<Object> getAllUsers(CommonProjectInfo prjInfo) {
        HashSet<Object> users = new HashSet<Object>(ProjectPermissions.getUsersRO(prjInfo));
        users.addAll(ProjectPermissions.getUsersRW(prjInfo));
        return users;
    }

    private static Set<Object> getUsers(CommonProjectInfo prjInfo, boolean readOnly) {
        HashSet<Object> users = (HashSet<Object>)prjInfo.getAttribute(readOnly ? USERS_RO : USERS_RW);
        if (users == null) {
            users = new HashSet<Object>();
            ProjectPermissions.setUsers(prjInfo, users, readOnly);
        }
        return users;
    }

    public static void setUsers(CommonProjectInfo prjInfo, Set<Object> users, boolean readOnly) {
        prjInfo.setAttribute(readOnly ? USERS_RO : USERS_RW, users);
    }

    public static void setUsersRO(CommonProjectInfo prjInfo, Set<Object> usersRO) {
        ProjectPermissions.setUsers(prjInfo, usersRO, true);
    }

    public static void setUsersRW(CommonProjectInfo prjInfo, Set<Object> usersRW) {
        ProjectPermissions.setUsers(prjInfo, usersRW, false);
    }

    public static boolean isPublic(CommonProjectInfo prjInfo) {
        SharingType type = ProjectPermissions.getSharingType(prjInfo);
        return type == SharingType.ALL_RO || type == SharingType.ALL_RW;
    }

    public static boolean isPrivate(CommonProjectInfo prjInfo) {
        return ProjectPermissions.getSharingType(prjInfo) == SharingType.PRIVATE;
    }

    public static boolean isShared(CommonProjectInfo prjInfo) {
        return ProjectPermissions.getSharingType(prjInfo) == SharingType.PARTIAL;
    }

    public static boolean userHasAccess(CommonProjectInfo prjInfo, Object userID) {
        if (ProjectPermissions.isPublic(prjInfo) || prjInfo.userId.equals(userID) || User.isAdmin(userID)) {
            return true;
        }
        SharingType sharingType = ProjectPermissions.getSharingType(prjInfo);
        if (sharingType == SharingType.PARTIAL) {
            return ProjectPermissions.getUsersRO(prjInfo).contains(userID) || ProjectPermissions.getUsersRW(prjInfo).contains(userID);
        }
        return false;
    }

    public static boolean userHasSelectiveAccessRO(CommonProjectInfo prjInfo, Object userID) {
        return ProjectPermissions.getSharingType(prjInfo) == SharingType.PARTIAL && ProjectPermissions.getUsersRO(prjInfo).contains(userID);
    }

    public static boolean userHasAccessRO(CommonProjectInfo prjInfo, Object userID) {
        return ProjectPermissions.getSharingType(prjInfo) == SharingType.ALL_RO || ProjectPermissions.userHasSelectiveAccessRO(prjInfo, userID);
    }

    public static boolean userHasSelectiveAccessRW(CommonProjectInfo prjInfo, Object userID) {
        return ProjectPermissions.getSharingType(prjInfo) == SharingType.PARTIAL && ProjectPermissions.getUsersRW(prjInfo).contains(userID);
    }

    public static boolean userHasSelectiveAccess(CommonProjectInfo prjInfo, Object userID) {
        return ProjectPermissions.getSharingType(prjInfo) == SharingType.PARTIAL && (ProjectPermissions.getUsersRO(prjInfo).contains(userID) || ProjectPermissions.getUsersRW(prjInfo).contains(userID));
    }

    public static boolean userHasAccessRW(CommonProjectInfo prjInfo, Object userID) {
        SharingType sharingType = ProjectPermissions.getSharingType(prjInfo);
        if (sharingType == SharingType.ALL_RW || ProjectPermissions.userOwnsProject(prjInfo, userID)) {
            return true;
        }
        return ProjectPermissions.userHasSelectiveAccessRW(prjInfo, userID);
    }

    public static boolean userOwnsProject(CommonProjectInfo prjInfo, Object userID) {
        return User.isAdmin(userID) || prjInfo.userId.equals(userID);
    }

    public static enum SharingType {
        PRIVATE,
        ALL_RO,
        ALL_RW,
        PARTIAL;

    }
}

