/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.BasicColumn;
import csbase.logic.algorithms.parameters.validators.BooleanParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public final class BooleanColumn
extends BasicColumn<Boolean> {
    private static final String DEFAULT_TRUE_COMMAND = "1";
    private static final String DEFAULT_FALSE_COMMAND = "0";
    private String falseCommand;
    private String trueCommand;

    public BooleanColumn(String id, String label, boolean defaultValue, boolean isEditable, String falseCommand, String trueCommand) {
        super(id, label, defaultValue, false, isEditable);
        this.setFalseCommand(falseCommand);
        this.setTrueCommand(trueCommand);
    }

    @Override
    public String getCommandValue(Boolean itemValue, CommandLineContext context) {
        if (itemValue == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "itemValue"));
        }
        if (context == null) {
            throw new IllegalArgumentException("O par\u00e2metro context n\u00e3o pode ser nulo.");
        }
        if (itemValue.booleanValue()) {
            return this.getTrueCommand();
        }
        return this.getFalseCommand();
    }

    public String getFalseCommand() {
        return this.falseCommand;
    }

    @Override
    public Boolean getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parameters.NullToBoolean"), this);
        }
        if (Boolean.TRUE.toString().equals(itemValue)) {
            return new Boolean(true);
        }
        if (Boolean.FALSE.toString().equals(itemValue)) {
            return new Boolean(false);
        }
        throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidBoolean"), itemValue, this);
    }

    public String getTrueCommand() {
        return this.trueCommand;
    }

    @Override
    public SimpleParameterValidator<Boolean> getValidator() {
        return new BooleanParameterValidator();
    }

    private void setFalseCommand(String command) {
        String cmd = command;
        if (cmd == null) {
            cmd = DEFAULT_FALSE_COMMAND;
        }
        this.falseCommand = cmd;
    }

    private void setTrueCommand(String command) {
        String cmd = command;
        if (cmd == null) {
            cmd = DEFAULT_TRUE_COMMAND;
        }
        this.trueCommand = cmd;
    }
}

