/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerListParameterListener;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.validators.IntegerParameterValidator;
import csbase.logic.algorithms.parameters.validators.ListParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public final class IntegerListParameter
extends ListParameter<Integer> {
    public static final String TYPE = "LIST_OF_INTEGERS";
    private transient List<IntegerListParameterListener> listeners = new LinkedList<IntegerListParameterListener>();
    private Integer maximum;
    private Integer minimum;

    public IntegerListParameter(String name, String label, String description, List<Integer> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, Integer maximum, Integer minimum) {
        super(name, label, description, defaultValue, isOptional, isVisible, false, true, commandLinePattern);
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public void addIntegerListParameterListener(IntegerListParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        this.listeners.add(listener);
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    public Integer getMinimum() {
        return this.minimum;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean setMaximum(Integer maximum) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MaxLessThanMin"));
        }
        if (this.maximum == null && maximum == null) {
            return false;
        }
        if (this.maximum != null && this.maximum.equals(maximum)) {
            return false;
        }
        this.maximum = maximum;
        this.updateValidator();
        for (IntegerListParameterListener listener : this.listeners) {
            listener.maximumWasChanged(this);
        }
        return true;
    }

    private void updateValidator() {
        ListParameterValidator listParameterValidator = (ListParameterValidator)this.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        validator.setMaximum(this.maximum);
        validator.setMinimum(this.minimum);
    }

    public boolean setMinimum(Integer minimum) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MinGreaterThenMax"));
        }
        if (this.minimum == null && minimum == null) {
            return false;
        }
        if (this.minimum != null && this.minimum.equals(minimum)) {
            return false;
        }
        this.minimum = minimum;
        this.updateValidator();
        for (IntegerListParameterListener listener : this.listeners) {
            listener.minimumWasChanged(this);
        }
        return true;
    }

    @Override
    public Integer getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            return null;
        }
        try {
            int intValue = Integer.parseInt(itemValue);
            return new Integer(intValue);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e, LNG.get((String)"csbase.logic.algorithms.parameters.InvalidIntegerParameter"), itemValue, this);
        }
    }

    protected IntegerParameterValidator createItemValidator() {
        return new IntegerParameterValidator(this.isOptional(), this.maximum, this.minimum);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<IntegerListParameterListener>();
    }

    @Override
    public void setJSONValue(Object value) {
        if (value == null) {
            this.setValue(null);
            return;
        }
        List list = (List)value;
        list.forEach(i -> this.addElement((Integer)i));
    }
}

