/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.columns.AbstractTableColumnFactory;

public final class DoubleColumnFactory
extends AbstractTableColumnFactory {
    private static final String ELEMENT_NAME = "coluna_de_reais";

    public DoubleColumnFactory() {
        super(ELEMENT_NAME);
    }

    @Override
    public void setCellValue(XmlParser parser, String parameterName, TableColumn<?> column, int rowIndex, String valueAttributeName) throws ParseException {
        DoubleColumn doubleColumn = (DoubleColumn)column;
        Double cellValue = parser.extractAttributeValueAsDouble(valueAttributeName, null, doubleColumn.getMaximum(), doubleColumn.getMinimum());
        doubleColumn.addDefaultValue(rowIndex, cellValue);
    }

    protected DoubleColumn createColumn(XmlParser parser, String parameterName, String label, String id, boolean isOptional, boolean isEditable, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Double maximum = parser.extractAttributeValueAsDouble("maximo", null, null, null);
        boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean("incluir_maximo", true);
        Double minimum = parser.extractAttributeValueAsDouble("minimo", null, maximum, null);
        boolean isMinimumIncluded = parser.extractAttributeValueAsBoolean("incluir_minimo", true);
        Double defaultValue = parser.extractAttributeValueAsDouble("padrao", null, maximum, minimum);
        parser.checkAttributes();
        parser.checkChildElements();
        return new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
    }
}

