/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationColumn;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parsers.EnumerationItemFactory;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.columns.AbstractTableColumnFactory;
import java.util.List;

public final class EnumerationColumnFactory
extends AbstractTableColumnFactory {
    private static final String ELEMENT_NAME = "coluna_de_enumeracao";

    public EnumerationColumnFactory() {
        super(ELEMENT_NAME);
    }

    @Override
    public void setCellValue(XmlParser parser, String parameterName, TableColumn<?> column, int rowIndex, String valueAttributeName) throws ParseException {
        EnumerationColumn enumerationColumn = (EnumerationColumn)column;
        String id = parser.extractAttributeValue(valueAttributeName);
        EnumerationItemFactory factory = new EnumerationItemFactory();
        EnumerationItem cellValue = factory.getEnumerationItem(String.format("%s[%s]", parameterName, id), enumerationColumn.getItems(), id);
        enumerationColumn.addDefaultValue(rowIndex, cellValue);
    }

    protected EnumerationColumn createColumn(XmlParser parser, String parameterName, String label, String id, boolean isOptional, boolean isEditable, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String defaultItemId = parser.extractAttributeValue("padrao");
        EnumerationItemFactory factory = new EnumerationItemFactory();
        List<EnumerationItem> items = factory.loadEnumerationItems(parser, parameterName);
        boolean mustSort = parser.extractAttributeValueAsBoolean("ordenar", true);
        EnumerationItem defaultItem = factory.getEnumerationItem(String.format("%s[%s]", parameterName, id), items, defaultItemId);
        parser.checkAttributes();
        return new EnumerationColumn(id, label, defaultItem, items, mustSort);
    }
}

