package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Gatilho Trocar Tipo de Arquivo: Modifica o tipo do arquivo aceito por um
 * {@link FileParameter parmetro do tipo Arquivo} quando a {@link Condition
 * condio} for aceita.
 * 
 * @author lmoreira
 */
public final class ChangeFileTypeTrigger extends Trigger<FileParameter> {
  /**
   * O tipo do arquivo.
   */
  private String fileType;

  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   * @param fileType O tipo do arquivo (Aceita {@code null}).
   */
  public ChangeFileTypeTrigger(FileParameter parameter, Condition condition,
    String fileType) {
    super(parameter, condition);
    this.fileType = fileType;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (super.equals(obj)) {
      ChangeFileTypeTrigger trigger = (ChangeFileTypeTrigger) obj;
      if (this.fileType == null && trigger.fileType == null) {
        return true;
      }
      return (this.fileType != null && this.fileType.equals(trigger.fileType));
    }
    return false;
  }

  /**
   * Obtm o tipo do arquivo.
   * 
   * @return O tipo do arquivo (Pode ser {@code null}).
   */
  public String getFileType() {
    return this.fileType;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setFileType(getFileType());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    // @todo Auto-generated method stub
  }
}
