package csbase.logic.algorithms.parsers;

import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;

/**
 * <p>
 * Analisador de {@link EnumerationParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo enumerao simples. O
 * elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link EnumerationParameter}.
 * </p>
 */
public class EnumerationParameterParser extends
  AbstractEnumerationParameterParser<EnumerationParameter> {

  /**
   * {@inheritDoc}
   */
  @Override
  protected EnumerationParameter createEnumerationParameter(XmlParser parser,
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, boolean mustSort,
    List<EnumerationItem> items, String defaultItemId) throws ParseException {

    // ATENO: Para seleo simples, assume que a enumerao no pode
    // ser vazia! Por enquanto, a seleo mltipla  o nico parmetro que
    // pode ser preenchido pelo carregador de parmetros.
    if (items.isEmpty()) {
      throw new ParseException(
        "Os itens da enumerao {0} no foram definidos.", name);
    }

    // Se o padro para a enumerao no foi definido, utilizamos o primeiro
    // tem.
    String defaultId = defaultItemId;
    if (defaultId == null) {
      defaultId = items.get(0).getId();
    }

    EnumerationItem defaultItem = getEnumerationItem(name, items, defaultId);
    EnumerationParameter parameter =
      new EnumerationParameter(name, label, description, defaultItem,
        isVisible, commandLinePattern, items, mustSort);
    items.remove(defaultItem);
    return parameter;
  }

}
