/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BasicColumn;

public final class BooleanColumn
extends BasicColumn<Boolean> {
    private static final String DEFAULT_TRUE_COMMAND = "1";
    private static final String DEFAULT_FALSE_COMMAND = "0";
    private String falseCommand;
    private String trueCommand;

    public BooleanColumn(String id, String label, boolean defaultValue, boolean isEditable, String falseCommand, String trueCommand) {
        super(id, label, defaultValue, false, isEditable);
        this.setFalseCommand(falseCommand);
        this.setTrueCommand(trueCommand);
    }

    @Override
    public String getCommandValue(Boolean itemValue) {
        if (itemValue == null) {
            throw new IllegalArgumentException("O par\u00e2metro itemValue n\u00e3o pode ser nulo.");
        }
        if (itemValue.booleanValue()) {
            return this.getTrueCommand();
        }
        return this.getFalseCommand();
    }

    public String getFalseCommand() {
        return this.falseCommand;
    }

    @Override
    public Boolean getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            throw new ParseException("N\u00e3o \u00e9 poss\u00edvel atribuir um valor nulo a uma coluna de booleanos.\nColuna envolvida: {0}.", this);
        }
        if (Boolean.TRUE.toString().equals(itemValue)) {
            return new Boolean(true);
        }
        if (Boolean.FALSE.toString().equals(itemValue)) {
            return new Boolean(false);
        }
        throw new ParseException("O valor {0} foi atribuido \u00e0 coluna {1}, por\u00e9m ele n\u00e3o \u00e9 um valor v\u00e1lido para um booleano.", itemValue, this);
    }

    public String getTrueCommand() {
        return this.trueCommand;
    }

    private void setFalseCommand(String command) {
        String cmd = command;
        if (cmd == null) {
            cmd = DEFAULT_FALSE_COMMAND;
        }
        this.falseCommand = cmd;
    }

    private void setTrueCommand(String command) {
        String cmd = command;
        if (cmd == null) {
            cmd = DEFAULT_TRUE_COMMAND;
        }
        this.trueCommand = cmd;
    }
}

