/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameterListener;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.FileParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FileParameter
extends SimpleParameter<FileParameterValue> {
    public static final String PATH = ".path";
    public static final String TYPE = ".type";
    private FileParameterPipeAcceptance usesPipe;
    private String fileType;
    private boolean hasLink;
    private transient List<FileParameterListener> listeners = new LinkedList<FileParameterListener>();
    private FileParameterMode mode;
    private boolean usesFilter;
    private final boolean mustExist;

    protected FileParameter(String name, String label, String description, FileParameterValue defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String fileType, FileParameterMode mode, FileParameterPipeAcceptance usesPipe, boolean usesFilter, boolean mustExist) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        this.fileType = fileType;
        this.hasLink = false;
        this.usesFilter = usesFilter;
        this.mustExist = mustExist;
        this.setUsesPipe(usesPipe);
        this.setMode(mode);
    }

    public final void addFileParameterListener(FileParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public final FileParameterPipeAcceptance usesPipe() {
        return this.usesPipe;
    }

    @Override
    public Map<String, Object> exportValue() {
        HashMap valuesByName = new HashMap();
        LinkedList exportableValues = new LinkedList();
        FileParameterValue file = (FileParameterValue)this.getValue();
        if (file != null) {
            HashMap<String, String> exportableValue = new HashMap<String, String>();
            exportableValue.put(PATH, file.getPath());
            exportableValue.put(TYPE, file.getType());
            exportableValues.add(Collections.unmodifiableMap(exportableValue));
            valuesByName.put(this.getName(), Collections.unmodifiableCollection(exportableValues));
        }
        return Collections.unmodifiableMap(valuesByName);
    }

    @Override
    public final String getCommandValue(CommandLineContext context) {
        FileParameterValue file = (FileParameterValue)this.getValue();
        if (file == null) {
            return null;
        }
        StringBuilder commandValue = new StringBuilder();
        char fileSeparator = context.getFileSeparator();
        if (file.getPath().startsWith("$")) {
            commandValue.append(file.getPath());
        } else {
            String path = file.getPath(fileSeparator);
            commandValue.append(CommandLineBuilder.makePathWithEnvironmentVariable(EnvironmentVariable.PROJECT_DIR, path, fileSeparator));
        }
        return commandValue.toString();
    }

    @Override
    public final Object getExpressionValue() {
        return null;
    }

    public final List<FileParameterListener> getFileParameterListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public final String getFileType() {
        return this.fileType;
    }

    public final FileParameterMode getMode() {
        return this.mode;
    }

    @Override
    public final String getValueAsText() {
        FileParameterValue file = (FileParameterValue)this.getValue();
        if (file == null) {
            return null;
        }
        String type = file.getType();
        if (type == null || type.trim().isEmpty()) {
            type = "UNKNOWN";
        }
        String valueAsText = file.getPath() + ":" + type;
        return valueAsText;
    }

    public final boolean hasLink() {
        return this.hasLink;
    }

    public boolean usesFilter() {
        return this.usesFilter;
    }

    @Override
    public void importValue(Map<String, Object> parameterValues) {
        Collection exportableValues = (Collection)parameterValues.get(this.getName());
        if (exportableValues != null && !exportableValues.isEmpty()) {
            Map exportableValue = (Map)exportableValues.iterator().next();
            String path = (String)exportableValue.get(PATH);
            String type = (String)exportableValue.get(TYPE);
            FileParameterValue file = new FileParameterValue(path, type);
            this.setValue(file);
        } else {
            this.setValue(null);
        }
    }

    public final boolean removeFileParameterListener(FileParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        return this.listeners.add(listener);
    }

    public final void setFileType(String fileType) {
        this.fileType = fileType;
        for (FileParameterListener listener : this.listeners) {
            listener.typeWasChanged(this);
        }
        this.fireVisiblityWasChangedEvent();
    }

    public final void setHasLink(boolean hasLink) {
        this.hasLink = hasLink;
        for (FileParameterListener listener : this.listeners) {
            listener.hasLinkWasChanged(this);
        }
        this.fireVisiblityWasChangedEvent();
    }

    @Override
    public final void setValueAsText(String parameterValue) {
        String type;
        String path;
        if (parameterValue == null || parameterValue.length() == 0) {
            this.setValue(null);
            return;
        }
        Pattern withTypePattern = Pattern.compile("^(.+):(.*)$");
        Matcher withTypeMatcher = withTypePattern.matcher(parameterValue);
        if (withTypeMatcher.matches()) {
            path = withTypeMatcher.group(1);
            type = withTypeMatcher.group(2);
        } else {
            path = parameterValue;
            type = null;
        }
        if (type == null || type.trim().isEmpty()) {
            type = this.mode == FileParameterMode.DIRECTORY ? "DIRECTORY_TYPE" : "UNKNOWN";
        }
        FileParameterValue file = new FileParameterValue(path, type);
        this.setValue(file);
    }

    private void setMode(FileParameterMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("O par\u00e2metro mode est\u00e1 nulo.");
        }
        this.mode = mode;
    }

    private void setUsesPipe(FileParameterPipeAcceptance usesPipe) {
        if (usesPipe == null) {
            throw new IllegalArgumentException("O par\u00e2metro usesPipe est\u00e1 nulo.");
        }
        this.usesPipe = usesPipe;
    }

    public void setUsesFilter(boolean usesFilter) {
        this.usesFilter = usesFilter;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<FileParameterListener>();
    }

    public FileParameterValidator createParameterValidator() {
        return new FileParameterValidator(this.isOptional());
    }

    public boolean mustExist() {
        return this.mustExist;
    }
}

