/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.ParameterLoader;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.EnumerationParameterParser;
import csbase.logic.algorithms.parsers.HiddenParameterParser;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.ParameterLoaderParser;
import csbase.logic.algorithms.parsers.ParameterParser;
import csbase.logic.algorithms.parsers.TriggerParser;
import csbase.logic.algorithms.parsers.ValidationExpressionParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SimpleAlgorithmParser
extends ParameterParser {
    static final String ALGORITHM_ELEMENT = "algoritmo";
    static final String ALGORITHM_ELEMENT_ABBREVIATION_ATTRIBUTE = "abreviatura";
    static final String ALGORITHM_ELEMENT_COMMAND_ATTRIBUTE = "comando";
    static final String ALGORITHM_ELEMENT_DEFAULT_INPUT_FILE_ATTRIBUTE = "arquivo_de_entrada_padrao";
    static final String ALGORITHM_ELEMENT_EXECUTION_TYPE_ATTRIBUTE = "tipo_de_execucao";
    static final String ALGORITHM_ELEMENT_EXECUTION_LOCATION_ATTRIBUTE = "local_de_execucao";
    static final String ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUE_SIMPLE = "simples";
    static final String[] ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUES_MULTIPLE = new String[]{"multipla", "m\u00faltipla"};
    static final String ALGORITHM_ELEMENT_PROVIDE_ID_ATTRIBUTE = "fornecer_identificador";
    static final boolean ALGORITHM_ELEMENT_PROVIDE_ID_DEFAULT_VALUE = false;
    static final String ALGORITHM_ELEMENT_SHOW_OUTPUT_ATTRIBUTE = "exibir_saida";
    static final boolean ALGORITHM_ELEMENT_SHOW_OUTPUT_DEFAULT_VALUE = false;
    static final String ALGORITHM_ELEMENT_SHELL_ATTRIBUTE = "shell";
    static final String ALGORITHM_ELEMENT_CAPTURE_EXIT_CODE_ATTRIBUTE = "capturar_codigo_de_saida";
    static final boolean ALGORITHM_ELEMENT_CAPTURE_EXIT_CODE_DEFAULT_VALUE = false;
    static final String DESCRIPTION_ELEMENT = "descricao";
    static final String GROUP_ELEMENT = "grupo";
    static final String GROUP_ELEMENT_LABEL_ATTRIBUTE = "rotulo";
    static final String GROUP_ELEMENT_ID_ATTRIBUTE = "id";
    static final String GROUP_ELEMENT_COLLAPSIBLE_ATTRIBUTE = "minimizavel";
    static final boolean GROUP_ELEMENT_COLLAPSIBLE_ATTRIBUTE_DEFAULT_VALUE = false;
    static final String PARAMETER_ELEMENT = "parametro";
    private String currentCommandLinePattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleAlgorithmConfigurator load(Reader configXmlReader, Map<String, String> paramConfigProperties, Map<String, String> paramProperties, AlgorithmVersionInfo algorithmVersion, ExecutionLocation defaultExecutionLocation, String defaultCommandLinePattern) throws ParseException {
        if (configXmlReader == null) {
            throw new IllegalArgumentException("O par\u00e2metro configXmlReader est\u00e1 nulo.");
        }
        if (algorithmVersion == null) {
            throw new IllegalArgumentException("O par\u00e2metro algorithmVersion est\u00e1 nulo.");
        }
        if (paramConfigProperties == null) {
            throw new IllegalArgumentException("O par\u00e2metro replacementMap est\u00e1 nulo.");
        }
        if (paramProperties == null) {
            throw new IllegalArgumentException("O par\u00e2metro paramProperties est\u00e1 nulo.");
        }
        XmlParser parser = new XmlParser(paramConfigProperties);
        parser.parseDocument(configXmlReader);
        parser.goToRoot();
        parser.ensureElementName(ALGORITHM_ELEMENT);
        String command = parser.extractAttributeValue(ALGORITHM_ELEMENT_COMMAND_ATTRIBUTE);
        String shell = parser.extractAttributeValue(ALGORITHM_ELEMENT_SHELL_ATTRIBUTE, null);
        boolean captureExitCode = parser.extractAttributeValueAsBoolean(ALGORITHM_ELEMENT_CAPTURE_EXIT_CODE_ATTRIBUTE, false);
        String defaultInputFileParameterName = parser.extractAttributeValue(ALGORITHM_ELEMENT_DEFAULT_INPUT_FILE_ATTRIBUTE, null);
        boolean provideId = parser.extractAttributeValueAsBoolean(ALGORITHM_ELEMENT_PROVIDE_ID_ATTRIBUTE, false);
        boolean showOutput = parser.extractAttributeValueAsBoolean(ALGORITHM_ELEMENT_SHOW_OUTPUT_ATTRIBUTE, false);
        String description = this.loadDescription(parser);
        ExecutionType executionType = this.loadExecutionType(parser);
        ExecutionLocation executionLocation = parser.extractAttributeValueAsEnumeration(ALGORITHM_ELEMENT_EXECUTION_LOCATION_ATTRIBUTE, defaultExecutionLocation, new ExecutionLocation.ExecutionLocationConverter());
        String abbreviation = parser.extractAttributeValue(ALGORITHM_ELEMENT_ABBREVIATION_ATTRIBUTE, null);
        this.currentCommandLinePattern = this.loadCommandLinePattern(parser, defaultCommandLinePattern);
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersion, description, executionType, executionLocation, abbreviation, provideId, command, shell, defaultInputFileParameterName, showOutput, this.currentCommandLinePattern);
        try {
            configurator.setHasExitCode(captureExitCode);
            this.loadGroups(parser, configurator, paramProperties);
            this.loadExpressions(parser, configurator);
            this.loadTriggers(parser, configurator);
            this.loadHiddenParameters(parser, configurator);
            this.checkDefaultInputFileParameter(defaultInputFileParameterName, configurator);
            parser.checkAttributes();
            parser.goToRoot();
        }
        finally {
            this.currentCommandLinePattern = defaultCommandLinePattern;
        }
        return configurator;
    }

    private void loadTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        TriggerParser triggerParser = new TriggerParser();
        triggerParser.loadTriggers(parser, configurator);
    }

    public void loadModifications(SimpleAlgorithmConfigurator configurator, Reader configXmlReader) throws ParseException {
        XmlParser parser = new XmlParser(new HashMap<String, String>());
        parser.parseDocument(configXmlReader);
        parser.goToRoot();
        parser.ensureElementName(ALGORITHM_ELEMENT);
        parser.checkAttributes();
        boolean hasElements = parser.goToFirstChild();
        while (hasElements) {
            parser.ensureElementName(PARAMETER_ELEMENT);
            String name = parser.extractAttributeValue("nome");
            parser.checkAttributes();
            SimpleParameter<?> parameter = configurator.getSimpleParameter(name);
            if (parameter == null) {
                throw new ParseException("O par\u00e2metro {0} n\u00e3o foi encontrado.", name);
            }
            if (!(parameter instanceof EnumerationListParameter)) {
                throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo suportado. O \u00fanico tipo de par\u00e2metro suportado \u00e9 o {1} com selec\u00e3o m\u00faltipla.", name, "enumeracao");
            }
            EnumerationListParameter enumParameter = (EnumerationListParameter)parameter;
            EnumerationParameterParser enumerationParser = new EnumerationParameterParser();
            List<EnumerationItem> items = enumerationParser.loadEnumerationItems(parser, name);
            enumParameter.setItems(items);
            hasElements = parser.goToNextSibling();
        }
        parser.goToRoot();
    }

    private void checkDefaultInputFileParameter(String defaultInputFileParameterName, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (defaultInputFileParameterName != null) {
            List<InputFileParameter> inputFileParameters = configurator.getInputFileParameters();
            for (InputFileParameter inputFileParameter : inputFileParameters) {
                if (!inputFileParameter.getName().equals(defaultInputFileParameterName)) continue;
                return;
            }
            throw new ParseException("O par\u00e2metro {0} utilizado no atributo {1} do elemento {2} n\u00e3o foi definido neste algoritmo ({3} - {4}).", defaultInputFileParameterName, ALGORITHM_ELEMENT_DEFAULT_INPUT_FILE_ATTRIBUTE, ALGORITHM_ELEMENT, configurator.getAlgorithmVersion().getInfo(), configurator.getAlgorithmVersion().getId());
        }
    }

    private void checkParameterLoader(ParameterGroup group) throws ParseException {
        ParameterLoader parameterLoader = group.getParameterLoader();
        if (parameterLoader != null) {
            for (String inputParameterName : parameterLoader.getInputParameterNames()) {
                if (group.getSimpleParameter(inputParameterName) != null) continue;
                throw new ParseException("O par\u00e2metro {0} referenciado pelo elemento {1} n\u00e3o existe.", inputParameterName, "parametro_de_entrada");
            }
        }
    }

    private String loadDescription(XmlParser parser) throws ParseException {
        if (!parser.goToFirstChild(DESCRIPTION_ELEMENT)) {
            return null;
        }
        String description = parser.getElementValue(null);
        parser.checkAttributes();
        parser.checkChildElements();
        parser.goToParent();
        return description;
    }

    private ExecutionType loadExecutionType(XmlParser parser) throws ParseException {
        String executionTypeName = parser.extractAttributeValue(ALGORITHM_ELEMENT_EXECUTION_TYPE_ATTRIBUTE, ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUE_SIMPLE);
        if (executionTypeName.equals(ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUE_SIMPLE)) {
            return ExecutionType.SIMPLE;
        }
        for (String value : ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUES_MULTIPLE) {
            if (!executionTypeName.equals(value)) continue;
            return ExecutionType.MULTIPLE;
        }
        throw new ParseException("O valor {0} do atributo {1} do elemento {2} n\u00e3o \u00e9 um tipo de execu\u00e7\u00e3o v\u00e1lido.", executionTypeName, ALGORITHM_ELEMENT_EXECUTION_TYPE_ATTRIBUTE, ALGORITHM_ELEMENT);
    }

    private void loadExpressions(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (parser.goToFirstChild("expressao")) {
            ValidationExpressionParser expressionParser = new ValidationExpressionParser();
            do {
                expressionParser.loadExpression(parser, configurator);
            } while (parser.goToNextSibling("expressao"));
            parser.goToParent();
        }
    }

    private ParameterGroup loadGroup(XmlParser parser, Map<String, String> params) throws ParseException {
        String groupLabel = parser.extractAttributeValue(GROUP_ELEMENT_LABEL_ATTRIBUTE);
        String groupId = parser.extractAttributeValue(GROUP_ELEMENT_ID_ATTRIBUTE, groupLabel);
        boolean isCollapsible = parser.extractAttributeValueAsBoolean(GROUP_ELEMENT_COLLAPSIBLE_ATTRIBUTE, false);
        ParameterGroup group = new ParameterGroup(groupId, groupLabel, isCollapsible);
        if (parser.goToFirstChild()) {
            do {
                Parameter parameter = null;
                String elementName = parser.getElementName();
                if (elementName.equals(GROUP_ELEMENT)) {
                    parameter = this.loadGroup(parser, params);
                } else if (elementName.equals("carregar_parametros")) {
                    ParameterLoaderParser parameterLoaderParser = new ParameterLoaderParser();
                    parameterLoaderParser.loadParameterLoader(parser, group);
                } else {
                    parameter = this.loadSimpleParameter(parser, params, group);
                }
                if (parameter == null || group.addParameter(parameter)) continue;
                throw new ParseException("J\u00e1 existe um par\u00e2metro {0} com este no grupo {1}.", parameter, group);
            } while (parser.goToNextSibling());
            parser.goToParent();
        }
        parser.checkAttributes();
        this.checkParameterLoader(group);
        return group;
    }

    private Parameter<?> loadSimpleParameter(XmlParser parser, Map<String, String> customParamsMap, ParameterGroup group) throws ParseException {
        String elementName = parser.getElementName();
        if (customParamsMap.containsKey(elementName)) {
            String factoryClassName = customParamsMap.get(elementName);
            try {
                ParameterFactory factory = this.createParameterFactory(factoryClassName);
                return factory.createParameter(parser, this.currentCommandLinePattern, group);
            }
            catch (OperationFailureException e) {
                throw new ParseException("N\u00e3o foi poss\u00edvel criar o elemento {0} a partir da f\u00e1brica {1}. <br> {2}", elementName, factoryClassName, e.getMessage());
            }
        }
        throw new ParseException("N\u00e3o foi poss\u00edvel criar o elemento {0}, pois este n\u00e3o pertence ao conjunto de par\u00e2metros aceitos pelo configurador.", elementName);
    }

    private ParameterFactory createParameterFactory(String factoryClassName) throws OperationFailureException {
        ParameterFactory factory;
        Constructor<?> factoryConstructor;
        Class<?> factoryClass;
        try {
            factoryClass = Class.forName(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            throw new OperationFailureException("A classe {0} n\u00e3o foi encontrada.", factoryClassName);
        }
        if (!ParameterFactory.class.isAssignableFrom(factoryClass)) {
            throw new OperationFailureException("A classe {0} n\u00e3o implementa a interface necess\u00e1ria {1}.", factoryClassName, ParameterFactory.class.getName());
        }
        try {
            factoryConstructor = factoryClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new OperationFailureException("N\u00e3o existe um construtor vazio em {0}.", factoryClassName);
        }
        try {
            factory = (ParameterFactory)factoryConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new OperationFailureException(MessageFormat.format("N\u00e3o foi poss\u00edvel construir a f\u00e1brica {0}.", factoryClassName), e);
        }
        catch (IllegalAccessException e) {
            throw new OperationFailureException(MessageFormat.format("Construtor da f\u00e1brica {0} n\u00e3o aceita os par\u00e2metros usados.", factoryClassName), e);
        }
        catch (InvocationTargetException e) {
            throw new OperationFailureException(MessageFormat.format("Erro ao construir a f\u00e1brica de par\u00e2metros {0}.", factoryClassName), e.getTargetException());
        }
        return factory;
    }

    private void loadGroups(XmlParser parser, SimpleAlgorithmConfigurator configurator, Map<String, String> customParamsMap) throws ParseException {
        if (parser.goToFirstChild(GROUP_ELEMENT)) {
            do {
                ParameterGroup group;
                if (configurator.addGroup(group = this.loadGroup(parser, customParamsMap))) continue;
                throw new ParseException("J\u00e1 existe um grupo {0} cadastrado no algoritmo {1}.", group, configurator);
            } while (parser.goToNextSibling(GROUP_ELEMENT));
            parser.goToParent();
        }
    }

    private void loadHiddenParameters(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (parser.goToFirstChild("oculto")) {
            HiddenParameterParser hiddenParameterParser = new HiddenParameterParser();
            do {
                HiddenParameter hiddenParameter;
                if (configurator.addHiddenParameter(hiddenParameter = hiddenParameterParser.createParameter(parser, this.currentCommandLinePattern, null))) continue;
                throw new ParseException("J\u00e1 existe um grupo {0} cadastrado no algoritmo {1}.", hiddenParameter, configurator);
            } while (parser.goToNextSibling("oculto"));
            parser.goToParent();
        }
    }
}

