/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.client.ClientLocalFile;
import csbase.console.AbstractConsoleApp;
import csbase.console.ExitCode;
import csbase.console.ImportAlgoVersionParams;
import csbase.logic.ClientFile;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.remote.ClientRemoteLocator;
import java.io.File;
import java.io.InputStream;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;

class ImportAlgoVersion
extends AbstractConsoleApp {
    ImportAlgoVersion(String[] args) {
        super(args);
    }

    @Override
    protected ImportAlgoVersionParams createParams() {
        return new ImportAlgoVersionParams();
    }

    @Override
    protected void postLoginInit() {
    }

    /*
     * Loose catch block
     */
    private static boolean transfer(ClientFile file, RemoteFileChannelInfo info) throws Exception {
        SyncRemoteFileChannel channel = new SyncRemoteFileChannel(info.getIdentifier(), info.isWritable(), info.getHost(), info.getPort(), info.getKey());
        channel.open(!info.isWritable());
        try {
            try (InputStream inputStream = file.getInputStream();){
                long totalBytes = channel.syncTransferFrom(inputStream, 0L, file.size());
                boolean bl = totalBytes == file.size();
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            channel.close();
        }
    }

    @Override
    protected boolean preLogout() {
        return true;
    }

    @Override
    public String getLogin() {
        ImportAlgoVersionParams params = (ImportAlgoVersionParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    private File getLocalSrcFile(String localSrcPath) {
        File localFile = localSrcPath.charAt(0) != '/' ? new File(this.getCurrentDir(), localSrcPath) : new File(localSrcPath);
        if (!localFile.exists()) {
            this.printError(localSrcPath + " n\u00e3o existe", new Object[0]);
            return null;
        }
        if (localFile.isDirectory()) {
            this.printError(localSrcPath + " \u00e9 um diret\u00f3rio", new Object[0]);
            return null;
        }
        return localFile;
    }

    @Override
    public ExitCode execute() throws Exception {
        ImportAlgoVersionParams params = (ImportAlgoVersionParams)this.getParams();
        return this.startAlgorithmImport(params.algorithmId, params.versionZipPath);
    }

    private ExitCode startAlgorithmImport(String algorithmId, String zipPath) throws Exception {
        AlgorithmInfo info = ClientRemoteLocator.algorithmService.getInfo((Object)algorithmId);
        if (info == null) {
            System.err.println("Id de algoritmo inv\u00e1lido.");
            return ExitCode.FAILURE;
        }
        String filename = FileUtils.getFileName((String)zipPath);
        RemoteFileChannelInfo channelInfo = ClientRemoteLocator.algorithmService.prepareUploadVersionPack((Object)algorithmId, filename);
        File localFile = this.getLocalSrcFile(zipPath);
        if (localFile == null) {
            System.err.println("Path inexistente para vers\u00e3o de algoritmo.");
            return ExitCode.FAILURE;
        }
        ClientLocalFile clientFile = new ClientLocalFile(localFile);
        if (!ImportAlgoVersion.transfer((ClientFile)clientFile, channelInfo)) {
            System.out.println("Falha na transfer\u00eancia da vers\u00e3o de algoritmo.");
            return ExitCode.FAILURE;
        }
        System.out.println("Vers\u00e3o de algoritmo importada com sucesso.");
        return ExitCode.SUCCESS;
    }
}

