# $Id$
#
# Este arquivo define variáveis de ambiente correspondentes às libs
# disponibilizadas pelo CSBase para os outros projetos, para facilitar
# e centralizar as referências a estas. Upgrades de versões de
# bibliotecas serão atualizados aqui, e todos os scripts que fizerem
# uso deste arquivo automaticamente utilizarão as novas versões.
# 
# O único pré-requisito é que a variável de ambiente CSBASE_DIR seja
# definida para apontar para o diretório-raiz do CSBase. Como este local
# varia de projeto para projeto, esta definição deve ser feita nos
# scripts _antes_ da inclusão deste script.
#
# O uso típico deste arquivo é:
# ...
# CSBASE_DIR=[path para o diretório pai de csbase]
# . $CSBASE_DIR/conf/csbase.sh
# ...

# Função para trocar o separador ":" por espaços. Funciona apenas para
# as variáveis UNIX.
#
# Exemplos de uso:
# FILES=`withSpaces $JAR_JACORB`
# cp `withSpaces $JAR_JACORB` /tmp
withSpaces () {
    print "$@" | tr : \ 
}

# a variável CSBASE_LIBS deve ter sido previamente definida
export CSBASE_LIBS=$CSBASE_DIR/csbase/libs

# converte um classpath UNIX para Windows
toWin () {
    print $1 | tr ':' ';' | sed "s,/,\\\\\\\\,g"
}

# Busca dentro de um diretório todos os JARs que devem ser incluídos no 
# classpath (para cada subdiretório), gerando dinamicamente uma variável 
# com o nome:
# JAR_<NOME_DIR>=<DIRECTORY>/<nome_dir>/*, onde DIRECTORY é $1.
# As variáveis JAR_xxx_WIN são geradas dinamicamente a partir das
# variáveis JAR_xxx correspondentes
processJarDirectory() {
 directory="$1"
 for subdir in ${directory}/* ; do
     if test -d $subdir ; then
       subdirname="$(basename $subdir)"
       DIR="$(print $subdirname | tr '[a-z]-' '[A-Z]_')"
       files="$(find $directory/$subdirname -type d -name .svn -prune -o -type f -name '*jar' -print)"
       classpathJars="$(print $files | tr ' ' ':')"
       eval "export JAR_${DIR}=\"$classpathJars\""
       set -f
       eval "export JAR_${DIR}_WIN=\"$(toWin $classpathJars)\""
       set +f
     fi
 done
}


processJarDirectory ${CSBASE_LIBS} 
