/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.access;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.access.resource.FindAllResourceTypesCommand;
import br.com.petrobras.security.command.management.access.resource.FindAllResourcesCommand;
import br.com.petrobras.security.command.management.access.resource.FindResourceByIdCommand;
import br.com.petrobras.security.command.management.access.resource.FindResourcesByIdsCommand;
import br.com.petrobras.security.command.management.access.resource.RemoveResourceByIdCommand;
import br.com.petrobras.security.command.management.access.resource.SaveResourceCommand;
import br.com.petrobras.security.command.management.access.resource.UpdateResourceCommand;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.access.IResourceManager;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.model.ResourceType;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class ResourceManagerCoreImpl
implements IResourceManager {
    public void save(Resource resource) throws InvalidArgumentException, PermissionDeniedException, ConstraintViolationException, InvalidOperationException, SecurityException {
        SaveResourceCommand cmd = ICommandIdentifier.getInstance().getSaveResourceCommand();
        cmd.setResourceArg(resource);
        cmd.execute();
    }

    public void update(String oldResourceId, Resource newResourceToUpdate) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        UpdateResourceCommand cmd = ICommandIdentifier.getInstance().getUpdateResourceCommand();
        cmd.setOldResourceIdArg(oldResourceId);
        cmd.setResourceArg(newResourceToUpdate);
        cmd.execute();
    }

    public void update(Resource newResourceToUpdate) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        UpdateResourceCommand cmd = ICommandIdentifier.getInstance().getUpdateResourceCommand();
        cmd.setResourceArg(newResourceToUpdate);
        cmd.execute();
    }

    public void remove(Resource resource) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resource);
        this.remove(resource.getId());
    }

    public void remove(String resourceId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        RemoveResourceByIdCommand cmd = ICommandIdentifier.getInstance().getRemoveResourceByIdCommand();
        cmd.setResourceIdArg(resourceId);
        cmd.execute();
    }

    public Resource find(String resourceId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindResourceByIdCommand cmd = ICommandIdentifier.getInstance().getFindResourceByIdCommand();
        cmd.setResourceIdArg(resourceId);
        return (Resource)cmd.execute();
    }

    public List<Resource> find(List<String> resourceIds) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindResourcesByIdsCommand cmd = ICommandIdentifier.getInstance().getFindResourcesByIdsCommand();
        cmd.setResourceIdsArg(resourceIds);
        return (List)cmd.execute();
    }

    public List<Resource> findAll() throws PermissionDeniedException, SecurityException {
        FindAllResourcesCommand cmd = ICommandIdentifier.getInstance().getFindAllResourcesCommand();
        return (List)cmd.execute();
    }

    public List<ResourceType> findAllTypes() throws PermissionDeniedException, SecurityException {
        FindAllResourceTypesCommand cmd = ICommandIdentifier.getInstance().getFindAllResourceTypesCommand();
        return (List)cmd.execute();
    }
}

