/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.information;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.information.FindAllInformationsInAllRegionalsCommand;
import br.com.petrobras.security.command.management.information.FindInformationByIdInRegionalCommand;
import br.com.petrobras.security.command.management.information.information.FindAllInformationSharingTypesCommand;
import br.com.petrobras.security.command.management.information.information.FindAllInformationsCommand;
import br.com.petrobras.security.command.management.information.information.FindAllInformationsInRegionalCommand;
import br.com.petrobras.security.command.management.information.information.FindAllInformationsWithSharingFilterCommand;
import br.com.petrobras.security.command.management.information.information.FindInformationByIdCommand;
import br.com.petrobras.security.command.management.information.information.FindInformationByUidCommand;
import br.com.petrobras.security.command.management.information.information.FindInformationsByIdCommand;
import br.com.petrobras.security.command.management.information.information.RemoveInformationCommand;
import br.com.petrobras.security.command.management.information.information.SaveInformationCommand;
import br.com.petrobras.security.command.management.information.information.UpdateInformationCommand;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.information.IInformationManager;
import br.com.petrobras.security.model.Information;
import br.com.petrobras.security.model.InformationSharingType;
import br.com.petrobras.security.model.InformationSharingTypeEnum;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class InformationManagerCoreImpl
implements IInformationManager {
    public Information find(Long informationUid) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindInformationByUidCommand cmd = ICommandIdentifier.getInstance().getFindInformationByUidCommand();
        cmd.setInformationUidArg(informationUid);
        return (Information)cmd.execute();
    }

    public Information find(String informationId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindInformationByIdCommand cmd = ICommandIdentifier.getInstance().getFindInformationByIdCommand();
        cmd.setInformationIdArg(informationId);
        return (Information)cmd.execute();
    }

    public List<Information> find(List<String> informationIds) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindInformationsByIdCommand cmd = ICommandIdentifier.getInstance().getFindInformationsByIdCommand();
        cmd.setInformationsIdsToFindArg(informationIds);
        return (List)cmd.execute();
    }

    public List<Information> findAll() throws PermissionDeniedException, SecurityException {
        FindAllInformationsCommand cmd = ICommandIdentifier.getInstance().getFindAllInformationsCommand();
        return (List)cmd.execute();
    }

    public List<InformationSharingType> findAllSharingTypes() {
        FindAllInformationSharingTypesCommand cmd = ICommandIdentifier.getInstance().getFindAllInformationSharingTypesCommand();
        return (List)cmd.execute();
    }

    public void save(Information information) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)information);
        SaveInformationCommand cmd = ICommandIdentifier.getInstance().getSaveInformationCommand();
        cmd.setInformationArg(information);
        cmd.execute();
    }

    public void update(Information information) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)information);
        this.update(information.getId(), information);
    }

    public void update(String oldId, Information information) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)information);
        UpdateInformationCommand cmd = ICommandIdentifier.getInstance().getUpdateInformationCommand();
        cmd.setOldIdArg(oldId);
        cmd.setInformationArg(information);
        cmd.execute();
    }

    public void remove(Information information) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)information);
        this.remove(information.getId());
    }

    public void remove(String informationId) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, PermissionDeniedException, SecurityException {
        RemoveInformationCommand cmd = ICommandIdentifier.getInstance().getRemoveInformationCommand();
        cmd.setInformationIdArg(informationId);
        cmd.execute();
    }

    public List<Information> findAllInAllRegionals() throws PermissionDeniedException, SecurityException {
        FindAllInformationsInAllRegionalsCommand cmd = ICommandIdentifier.getInstance().getFindAllInformationsInAllRegionalsCommand();
        return (List)cmd.execute();
    }

    public Information findByIdInRegional(String regionalId, String applicationCatalogIdOfInformationOwner, String informationId) throws ObjectNotFoundException, InvalidArgumentException, PermissionDeniedException, SecurityException {
        FindInformationByIdInRegionalCommand cmd = ICommandIdentifier.getInstance().getFindInformationByIdInEnvironmentCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdOwnerOfInformationArg(applicationCatalogIdOfInformationOwner);
        cmd.setInformationIdArg(informationId);
        return (Information)cmd.execute();
    }

    public List<Information> findAllWithSharingType(InformationSharingTypeEnum sharingType) throws InvalidArgumentException, PermissionDeniedException, SecurityException {
        return this.findAllWithSharingType(sharingType.getValue());
    }

    public List<Information> findAllWithSharingType(InformationSharingType sharingType) throws ObjectNotFoundException, InvalidArgumentException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)sharingType);
        FindAllInformationsWithSharingFilterCommand cmd = ICommandIdentifier.getInstance().getFindAllInformationsWithSharingFilterCommand();
        cmd.setSharingTypeArg(sharingType);
        return (List)cmd.execute();
    }

    public List<Information> findAllInRegional(String regionalId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllInformationsInRegionalCommand cmd = ICommandIdentifier.getInstance().getFindAllInformationsInRegionalCommand();
        cmd.setRegionalIdArg(regionalId);
        return (List)cmd.execute();
    }
}

