/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.configuration;

import br.com.petrobras.security.ISecurityContext;
import br.com.petrobras.security.configuration.SecuritySettings;
import br.com.petrobras.security.exception.ConfigurationException;
import br.com.petrobras.security.exception.InactivatedApplicationEnvironmentException;
import br.com.petrobras.security.exception.InvalidCredentialsException;
import org.apache.log4j.Logger;

public abstract class SecurityConfigurer {
    private static Logger LOGGER = Logger.getLogger(SecurityConfigurer.class);

    public void configure(boolean testConnection) {
        LOGGER.info((Object)"Iniciando configura\u00e7\u00e3o de seguran\u00e7a...");
        this.loadSpringApplicationContext();
        if (testConnection) {
            this.testApplicationConnection();
            SecuritySettings.setSavedLog(true);
        }
    }

    protected void testApplicationConnection() {
        try {
            ISecurityContext.getContext().getApplicationEnvironmentConnector().testConnection(SecuritySettings.getRegionalId(), SecuritySettings.getEnvironmentId(), SecuritySettings.getApplicationCatalogId(), SecuritySettings.getApplicationPassword());
        }
        catch (InvalidCredentialsException ice) {
            throw new ConfigurationException("Os dados de conex\u00e3o da aplica\u00e7\u00e3o com o servi\u00e7o do Controle de Acesso Corporativo est\u00e3o incorretos.", (Throwable)ice);
        }
        catch (InactivatedApplicationEnvironmentException iaex) {
            LOGGER.warn((Object)"A aplica\u00e7\u00e3o est\u00e1 inativa no ambiente configurado no Controle de Acesso Corporativo.", (Throwable)iaex);
        }
    }

    protected abstract void loadSpringApplicationContext();
}

