 /*
 * ResourceGroupAuthorizerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.authorization;

 import br.com.petrobras.security.consume.MessageHeader;
 import br.com.petrobras.security.consume.ReturnMessage;
 import br.com.petrobras.security.consume.authorization.IResourceGroupAuthorizerConsumer;
 import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
 import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
 import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
 import br.com.petrobras.security.context.identification.IUserContextIdentifier;
 import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessage;

 import java.io.Serializable;

/**
 * Implementao "SOAP" de um consumidor de autorizador em grupo de recurso.
 * 
 * @author Patrezze - YMPD
 * @since 3.0
 * @version 1.0
 *
 */
public class ResourceGroupAuthorizerConsumerSoapImpl implements
        IResourceGroupAuthorizerConsumer, Serializable {

    /* [ Constantes ] */

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 5206366371831446623L;
    
    /* [ Constantes ] */
    
    /* [ Dependences ] */ 

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.authorization.IResourceGroupAuthorizerConsumer#isAuthorizedToRole(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> isAuthorizedToRole(
            MessageHeader messageHeader, String resourceGroupId, String roleId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
            .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
            .isResourceGroupAuthorizedToRole(smhDTO, resourceGroupId, roleId);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }
    
    /* [ Operators ] */

}
