 /*
 * OccupationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.enterprise;

 import br.com.petrobras.security.consume.MessageHeader;
 import br.com.petrobras.security.consume.ReturnMessage;
 import br.com.petrobras.security.consume.management.enterprise.IOccupationManagerConsumer;
 import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
 import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
 import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
 import br.com.petrobras.security.context.identification.IUserContextIdentifier;
 import br.com.petrobras.security.model.Occupation;
 import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

 import java.util.List;

/**
 * Implementao "SOAP" do consumidor de gerenciador de cargo.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class OccupationManagerConsumerSoapImpl implements
        IOccupationManagerConsumer {

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */
    
    /* [ Caso de Uso "Consultar cargo" ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IOccupationManagerConsumer#find(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<Occupation> find(MessageHeader messageHeader,
            Long occupationCode) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findOccupationByCode(smhDTO, occupationCode);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithOccupationValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IOccupationManagerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<Occupation>> findAll(MessageHeader messageHeader) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllOccupations(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithOccupationListValue(rmDTO);
    }
    
    /* [ Caso de Uso "Consultar cargo" ] */

}
