/*
 * ConsumeSoapUtil
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities;

import br.com.petrobras.security.consume.soap.SecurityEndPoint;
import br.com.petrobras.security.exception.ConfigurationException;
import br.com.petrobras.security.server.service.soap.ISecurityEndPoint41;
import org.apache.log4j.Logger;

import javax.net.ssl.*;
import javax.xml.ws.BindingProvider;
import java.net.MalformedURLException;

/**
 * Utilitrio de consumo do servio SOAP.
 * 
 * @since 1.0
 * @version 1.1
 * 
 */
public class ConsumeSoapUtil {

    /**
     * Logger da classe.
     */
    private static final Logger LOGGER = Logger.getLogger(ConsumeSoapUtil.class);
    /**
     * "End Point" atual.
     */
    private static ISecurityEndPoint41 currentEndPoint = null;

    /**
     * Obtm o "End Point" atual.
     * 
     * @return "End Point" atual.
     */
    public static synchronized ISecurityEndPoint41 getCurrentEndPoint() {
        if (currentEndPoint == null) {
            load();
        }
        return currentEndPoint;
    }

    /**
     * Carrega o "End Point" atual.
     */
    private static void load() {
        try {
            acceptSSL();
            acceptAllHosts();

            currentEndPoint = new SecurityEndPoint().getSecurity41Port();

            maintainSession(currentEndPoint);
        } catch (MalformedURLException mfue) {
            throw new ConfigurationException("URL do WSDL do servio do Controle de Acesso Corporativo  invlida.", mfue);
        } catch (javax.xml.ws.WebServiceException wse) {
            if (isSSLKeyException(wse)) {
                throw new ConfigurationException("Certificado digital do servio do Controle de Acesso Corporativo no est presente na lista de certificados confiveis do Weblogic Server onde a aplicao est deployada. Entre em contato com a infraestrutura para realizar esta configurao.", wse);
            } else {
                throw new ConfigurationException("Erro de comunicao entre a aplicao e o servio do Controle de Acesso Corporativo.", wse);
            }
        } catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private static void maintainSession(ISecurityEndPoint41 currentEndPoint) {
        // Define que  necessrio manter a sesso com o cliente.

        ((BindingProvider) currentEndPoint).getRequestContext().put(BindingProvider.SESSION_MAINTAIN_PROPERTY, true);
    }

    public static void acceptSSL() {

        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {

            public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(
                    java.security.cert.X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(
                    java.security.cert.X509Certificate[] certs, String authType) {
            }
        }};

        // Install the all-trusting trust manager
        try {
            SSLContext sc = SSLContext.getInstance("SSL");

            sc.init(null, trustAllCerts, new java.security.SecureRandom());
            javax.net.ssl.HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        } catch (Exception e) {
            LOGGER.warn(e);
        }
    }

    private static void acceptAllHosts() {
        javax.net.ssl.HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {

            public boolean verify(String host, SSLSession session) {
                return true;
            }
        });
    }

    /**
     * Mximo da profundidade da causa da exceo que ser analisada.
     */
    private static final int MAX_DEPTH_CAUSE = 10;

    private static boolean isSSLKeyException(javax.xml.ws.WebServiceException e) {

        LOGGER.debug("Verificando se a exceo tem origem SSLKeyException.");

        Throwable cause = e.getCause();
        int count = 0;

        while (cause != null && count < MAX_DEPTH_CAUSE) {

            if (cause instanceof SSLKeyException) {
                return true;
            }

            count++;
            cause = cause.getCause();
        }

        return false;
    }

}
