package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.basic.AreaManagementAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.AreaManagementAuthorizationDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.List;
import java.util.Locale;

/**
 * Montador de autorizao de gerenciamento de administrao de rea.
 * 
 * @since 4.3
 * 
 */
public class AreaManagementAuthorizationMounter {

	/**
     * Monta um gestor de rea a partir de um gestor de rea de transferncia.
     * @param authDTO Gestor de rea de transferncia.
     * @param preferredUserLocale Idioma preferido do usuario.
     * @param supportedApplicationLanguages Idiomas suportados pelo sistema.
     * @return Gestor de rea.
     */
    public static AreaManagementAuthorization mountLocalObject (
            AreaManagementAuthorizationDTO authDTO, Locale preferredUserLocale, List<SupportedLanguage> supportedApplicationLanguages) {
        if (authDTO == null) {
            return null;
        } else {
            AreaManagementAuthorization auth = new AreaManagementAuthorization ();

            auth.setArea(AreaMounter.mountLocalObject(
            		authDTO.getArea(), preferredUserLocale, supportedApplicationLanguages
            		));
            auth.setCreationDate(DateMounter.mountLocalObject(authDTO.getCreationDate()));
            auth.setDataAuthorization(authDTO.isDataAuthorization());
            auth.setEnabled(authDTO.isEnabled());
            auth.setExpiration(ExpirationMounter.mountLocalObject(authDTO.getExpiration()));
            auth.setHierarchical(authDTO.isHierarchical());
            auth.setOwner(authDTO.isOwner());
            auth.setUid(authDTO.getUid());
            auth.setUser(UserMounter.mountModelObject(authDTO.getUser()));
                        
            return auth;
        }            
    }
    
    /**
     * Monta um gestor de rea de transferncia a partir de um gestor de rea.
     * @param auth
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return rea de transferncia
     */
    public static AreaManagementAuthorizationDTO mountTransferObject(
            AreaManagementAuthorization auth, List<SupportedLanguage> supportedApplicationLanguages) {
		if (auth == null) {
			return null;
		} else {
			AreaManagementAuthorizationDTO authDTO = new AreaManagementAuthorizationDTO();

			authDTO.setArea(AreaMounter
					.mountTransferObject(auth.getArea(),
							supportedApplicationLanguages));
			try {
				authDTO.setCreationDate(DateMounter
						.mountTransferObject(auth
								.getCreationDate()));
			} catch (DatatypeConfigurationException dce) {
				authDTO.setCreationDate(null);
			}
            authDTO.setEnabled(auth.isEnabled());
            authDTO.setExpiration(ExpirationMounter.mountTransferObject(auth.getExpiration()));
            authDTO.setHierarchical(auth.isHierarchical());
            authDTO.setOwner(auth.isOwner());
            authDTO.setUid (auth.getUid());
            authDTO.setUser(UserMounter.mountTransferObject(auth.getUser()));
            authDTO.setDataAuthorization(auth.hasDataAuthorization());
            
            
            

            return authDTO;
        }
    }
}
