/*
 * ReturnMessageMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.exception.ExceptionInfo;
import br.com.petrobras.security.model.*;
import br.com.petrobras.security.model.authorization.access.*;
import br.com.petrobras.security.model.authorization.access.map.ResourceAuthorizationMapItem;
import br.com.petrobras.security.model.authorization.basic.ApplicationEnvironmentManagementAuthorization;
import br.com.petrobras.security.model.authorization.basic.AreaManagementAuthorization;
import br.com.petrobras.security.model.authorization.configuration.EnvironmentAdministrationAuthorization;
import br.com.petrobras.security.model.authorization.configuration.RoleUseCaseAuthorization;
import br.com.petrobras.security.model.authorization.information.EnterpriseGroupInformationValueAuthorization;
import br.com.petrobras.security.model.authorization.information.RoleInformationValueAuthorization;
import br.com.petrobras.security.model.authorization.information.UserGroupInformationValueAuthorization;
import br.com.petrobras.security.model.authorization.information.UserInformationValueAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.model.inactivation.UserInactivation;
import br.com.petrobras.security.model.log.LogAuthentication;
import br.com.petrobras.security.model.security.TokenUser;
import br.com.petrobras.security.server.service.soap.*;

import java.util.*;
import java.util.Locale;

/**
 * Montador de mensagens de retorno.
 * 
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 * 
 */
public class ReturnMessageMounter {

    public static ReturnMessage<TokenUser> mountLocalObjectWithTokenUserValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<TokenUser> returnMessage = createInitialReturnMessage(returnMessageDTO);
            TokenUserDTO tokenUserDTO = (TokenUserDTO) returnMessageDTO
                    .getValue();
            returnMessage.setValue(TokenUserMounter
                    .mountLocalObject(tokenUserDTO));
            return returnMessage;
        }
    }

    public static ReturnMessage<Boolean> mountLocalObjectWithBooleanValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Boolean> returnMessage = createInitialReturnMessage(returnMessageDTO);
            returnMessage.setValue((Boolean) returnMessageDTO.getValue());
            return returnMessage;
        }
    }

    public static ReturnMessage<String> mountLocalObjectWithStringValue(SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<String> returnMessage = createInitialReturnMessage(returnMessageDTO);
            returnMessage.setValue((String) returnMessageDTO.getValue());
            return returnMessage;
        }
    }
    
    public static ReturnMessage<Role> mountLocalObjectWithRoleValue(
            SoapReturnMessage returnMessageDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Role> returnMessage = createInitialReturnMessage(returnMessageDTO);
            RoleDTO roleDTO = (RoleDTO) returnMessageDTO.getValue();
            returnMessage.setValue(RoleMounter.mountLocalObject(roleDTO,
                    preferredUserLanguage, supportedApplicationLanguages));
            return returnMessage;
        }
    }

    public static ReturnMessage<Resource> mountLocalObjectWithResourceValue(
            SoapReturnMessage returnMessageDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Resource> returnMessage = createInitialReturnMessage(returnMessageDTO);
            ResourceDTO resourceDTO = (ResourceDTO) returnMessageDTO.getValue();
            returnMessage.setValue(ResourceMounter.mountLocalObject(
                    resourceDTO, preferredUserLanguage,
                    supportedApplicationLanguages));
            return returnMessage;
        }
    }
    
    public static ReturnMessage<ResourceGroup> mountLocalObjectWithResourceGroupValue(SoapReturnMessage rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<ResourceGroup> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                ResourceGroupDTO resourceGroupDTO = (ResourceGroupDTO)rmDTO.getValue();
                returnMessage.setValue(ResourceGroupMounter.mountLocalObject(resourceGroupDTO, preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<List<ResourceGroup>> mountLocalObjectWithResourceGroupListValue(SoapReturnMessageWithListValue rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<ResourceGroup>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(ResourceGroupListMounter.mountLocalObject(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<List<ResourceGroupMembership>> mountLocalObjectWithResourceGroupMembershipListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<ResourceGroupMembership>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(ResourceGroupMembershipListMounter
                        .mountLocalObjectList(soapReturnMessageWithListValueDTO
                                .getValue(), preferredUserLanguage,
                                supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<Role>> mountLocalObjectWithRoleListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<Role>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(RoleListMounter.mountLocalObjectList(
                        soapReturnMessageWithListValueDTO.getValue(),
                        preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<Resource>> mountLocalObjectWithResourceListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<Resource>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(ResourceListMounter
                        .mountLocalObjectList(soapReturnMessageWithListValueDTO
                                .getValue(), preferredUserLanguage,
                                supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<UseCase> mountLocalObjectWithUseCaseValue(
            SoapReturnMessage returnMessageDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<UseCase> returnMessage = createInitialReturnMessage(returnMessageDTO);
            UseCaseDTO useCaseDTO = (UseCaseDTO) returnMessageDTO.getValue();
            returnMessage.setValue(UseCaseMounter.mountLocalObject(useCaseDTO,
                    preferredUserLanguage, supportedApplicationLanguages));
            return returnMessage;
        }
    }

    public static ReturnMessage<List<UseCase>> mountLocalObjectWithUseCaseListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<UseCase>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(UseCaseListMounter.mountLocalObjectList(
                        soapReturnMessageWithListValueDTO.getValue(),
                        preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<RoleResourceAuthorization>> mountLocalObjectWithRoleResourceAuthorizationListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<RoleResourceAuthorization>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(RoleResourceAuthorizationListMounter
                        .mountLocalObjectList(soapReturnMessageWithListValueDTO
                                .getValue(), preferredUserLanguage,
                                supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<List<RoleResourceGroupAuthorization>> mountLocalObjectWithRoleResourceGroupAuthorizationListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<RoleResourceGroupAuthorization>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(RoleResourceGroupAuthorizationListMounter
                        .mountLocalObjectList(soapReturnMessageWithListValueDTO
                                .getValue(), preferredUserLanguage,
                                supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<RoleAdministrationAuthorization>> mountLocalObjectWithRoleAdministrationAuthorizationListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<RoleAdministrationAuthorization>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage
                        .setValue(RoleAdministrationAuthorizationListMounter
                                .mountLocalObjectList(
                                        soapReturnMessageWithListValueDTO
                                                .getValue(),
                                        preferredUserLanguage,
                                        supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    private static <T> ReturnMessage<T> createInitialReturnMessage(
            SoapReturnMessage returnMessageDTO) {
        ReturnMessage<T> rmLoaded = new ReturnMessage<T>();
        rmLoaded.setNewTicket(
                TicketMounter.mountLocalObject(returnMessageDTO.getNewTicket()));

        if (returnMessageDTO.getExceptionInfo() != null) {
            rmLoaded.setExceptionInfo(new ExceptionInfo(returnMessageDTO
                    .getExceptionInfo().getCode(), returnMessageDTO
                    .getExceptionInfo().getMessage()));
        }

        return rmLoaded;
    }

    private static <T> ReturnMessage<T> createInitialReturnMessage(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO) {
        ReturnMessage<T> rmLoaded = new ReturnMessage<T>();
        rmLoaded.setNewTicket(
                TicketMounter.mountLocalObject(soapReturnMessageWithListValueDTO.getNewTicket()));

        if (soapReturnMessageWithListValueDTO.getExceptionInfo() != null) {
            rmLoaded.setExceptionInfo(new ExceptionInfo(
                    soapReturnMessageWithListValueDTO.getExceptionInfo()
                            .getCode(), soapReturnMessageWithListValueDTO
                            .getExceptionInfo().getMessage()));
        }

        return rmLoaded;
    }

    /**
     * Monta uma mensagem de retorno com lista de usurios a partir de uma
     * mensagem de retorno com lista de usurios de tranferncia SOAP.
     * 
     * @param rmDTO
     *            Mensagem de retorno com lista de usurios de tranferncia SOAP
     * @return Mensagem de retorno com lista de usurios
     */
    public static ReturnMessage<List<User>> mountLocalObjectWithUserListValue(
            SoapReturnMessageWithListValue rmDTO) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<User>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(UserListMounter.mountModelObject(rmDTO
                        .getValue()));
            }

            return returnMessage;
        }
    }
    
    /**
     * Monta uma mensagem de retorno com lista de usurios externos a partir de uma
     * mensagem de retorno com lista de usurios de tranferncia SOAP.
     * 
     * @param rmDTO
     *            Mensagem de retorno com lista de usurios externos de tranferncia SOAP
     * @return Mensagem de retorno com lista de usurios
     */
    public static ReturnMessage<List<ExternalUser>> mountLocalObjectWithExternalUserListValue(
            SoapReturnMessageWithListValue rmDTO) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<ExternalUser>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(ExternalUserListMounter.mountModelObject(rmDTO
                        .getValue()));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<User> mountLocalObjectWithUserValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<User> returnMessage = createInitialReturnMessage(returnMessageDTO);
            UserDTO userDTO = (UserDTO) returnMessageDTO.getValue();
            returnMessage.setValue(UserMounter.mountModelObject(userDTO));
            return returnMessage;
        }
    }
    
    public static ReturnMessage<ExternalUser> mountLocalObjectWithExternalUserValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<ExternalUser> returnMessage = createInitialReturnMessage(returnMessageDTO);
            ExternalUserDTO userDTO = (ExternalUserDTO) returnMessageDTO.getValue();
            returnMessage.setValue(ExternalUserMounter.mountModelObject(userDTO));
            return returnMessage;
        }
    }
    
    public static ReturnMessage<Occupation> mountLocalObjectWithOccupationValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Occupation> returnMessage = createInitialReturnMessage(returnMessageDTO);
            OccupationDTO occupationDTO = (OccupationDTO) returnMessageDTO.getValue();
            returnMessage.setValue(OccupationMounter.mountLocalObject(occupationDTO));
            return returnMessage;
        }
    }
    
    /**
     * Monta uma mensagem de retorno com lista de cargos a partir de uma
     * mensagem de retorno com lista de cargos de tranferncia SOAP.
     * 
     * @param rmDTO
     *            Mensagem de retorno com lista de cargos de tranferncia SOAP
     * @return Mensagem de retorno com lista de cargos
     */
    public static ReturnMessage<List<Occupation>> mountLocalObjectWithOccupationListValue(
            SoapReturnMessageWithListValue rmDTO) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<Occupation>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(OccupationListMounter
                        .mountLocalObject(rmDTO.getValue()));
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<Company> mountLocalObjectWithCompanyValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Company> returnMessage = createInitialReturnMessage(returnMessageDTO);
            CompanyDTO companyDTO = (CompanyDTO) returnMessageDTO.getValue();
            returnMessage.setValue(CompanyMounter.mountLocalObject(companyDTO));
            return returnMessage;
        }
    }
    
    /**
     * Monta uma mensagem de retorno com lista de empresas a partir de uma
     * mensagem de retorno com lista de empresas de tranferncia SOAP.
     * 
     * @param rmDTO
     *            Mensagem de retorno com lista de empresas de tranferncia SOAP
     * @return Mensagem de retorno com lista de empresas.
     */
    public static ReturnMessage<List<Company>> mountLocalObjectWithCompanyListValue(
            SoapReturnMessageWithListValue rmDTO) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<Company>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(CompanyListMounter
                        .mountLocalObject(rmDTO.getValue()));
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<Function> mountLocalObjectWithFunctionValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Function> returnMessage = createInitialReturnMessage(returnMessageDTO);
            FunctionDTO functionDTO = (FunctionDTO) returnMessageDTO.getValue();
            returnMessage.setValue(FunctionMounter.mountLocalObject(functionDTO));
            return returnMessage;
        }
    }
    
    /**
     * Monta uma mensagem de retorno com lista de funes a partir de uma
     * mensagem de retorno com lista de funes de tranferncia SOAP.
     * 
     * @param rmDTO
     *            Mensagem de retorno com lista de funes de tranferncia SOAP
     * @return Mensagem de retorno com lista de funes.
     */
    public static ReturnMessage<List<Function>> mountLocalObjectWithFunctionListValue(
            SoapReturnMessageWithListValue rmDTO) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<Function>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(FunctionListMounter
                        .mountLocalObject(rmDTO.getValue()));
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<Department> mountLocalObjectWithDepartmentValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Department> returnMessage = createInitialReturnMessage(returnMessageDTO);
            DepartmentDTO deparmentDTO = (DepartmentDTO) returnMessageDTO.getValue();
            returnMessage.setValue(DepartmentMounter.mountLocalObject(deparmentDTO));
            return returnMessage;
        }
    }
    
    /**
     * Monta uma mensagem de retorno com lista de funes a partir de uma
     * mensagem de retorno com lista de funes de tranferncia SOAP.
     * 
     * @param rmDTO
     *            Mensagem de retorno com lista de funes de tranferncia SOAP
     * @return Mensagem de retorno com lista de funes.
     */
    public static ReturnMessage<List<Department>> mountLocalObjectWithDepartmentListValue(
            SoapReturnMessageWithListValue rmDTO) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<Department>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(DepartmentListMounter
                        .mountLocalObject(rmDTO.getValue()));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<Regional> mountLocalObjectWithRegionalValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Regional> returnMessage = createInitialReturnMessage(returnMessageDTO);
            RegionalDTO regionalDTO = (RegionalDTO) returnMessageDTO.getValue();
            returnMessage.setValue(RegionalMounter
                    .mountLocalObject(regionalDTO));
            return returnMessage;
        }
    }

    public static ReturnMessage<List<Regional>> mountLocalObjectWithRegionalListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<Regional>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(RegionalListMounter
                        .mountLocalObjectList(soapReturnMessageWithListValueDTO
                                .getValue()));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<Environment> mountLocalObjectWithEnvironmentValue(
            SoapReturnMessage returnMessageDTO) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Environment> returnMessage = createInitialReturnMessage(returnMessageDTO);
            EnvironmentDTO environemntDTO = (EnvironmentDTO) returnMessageDTO
                    .getValue();
            returnMessage.setValue(EnvironmentMounter
                    .mountLocalObject(environemntDTO));
            return returnMessage;
        }
    }

    public static ReturnMessage<List<Environment>> mountLocalObjectWithEnvironmentListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<Environment>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(EnvironmentListMounter
                        .mountLocalObjectList(soapReturnMessageWithListValueDTO
                                .getValue()));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<Application> mountLocalObjectWithApplicationValue(
            SoapReturnMessage returnMessageDTO, Locale preferredUserLanguage) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<Application> returnMessage = createInitialReturnMessage(returnMessageDTO);
            ApplicationDTO applicationDTO = (ApplicationDTO) returnMessageDTO
                    .getValue();
            returnMessage.setValue(ApplicationMounter.mountLocalObject(
                    applicationDTO, preferredUserLanguage));
            return returnMessage;
        }
    }

    public static ReturnMessage<List<Application>> mountLocalObjectWithApplicationListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<Application>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(ApplicationListMounter
                        .mountLocalObjectList(soapReturnMessageWithListValueDTO
                                .getValue(), preferredUserLanguage));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<ApplicationEnvironmentManagementAuthorization>> mountLocalObjectWithApplicationEnvironmentManagementAuthorizationListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO, Locale preferredUserLanguage) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<ApplicationEnvironmentManagementAuthorization>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(ApplicationEnvironmentManagementAuthorizationListMounter
                        .mountLocalObjectList(soapReturnMessageWithListValueDTO.getValue(), preferredUserLanguage));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<ApplicationEnvironmentManagementAuthorization> mountLocalObjectWithApplicationEnvironmentManagementAuthorizationValue(
            SoapReturnMessage returnMessageDTO, Locale preferredUserLanguage) {
        if (returnMessageDTO == null) {
            return null;
        } else {
            ReturnMessage<ApplicationEnvironmentManagementAuthorization> returnMessage = createInitialReturnMessage(returnMessageDTO);
            ApplicationEnvironmentManagementAuthorizationDTO appEnvManagementAuthorizationDTO = 
                (ApplicationEnvironmentManagementAuthorizationDTO) returnMessageDTO.getValue();
            returnMessage.setValue(
                    ApplicationEnvironmentManagementAuthorizationMounter.mountLocalObject(
                            appEnvManagementAuthorizationDTO, preferredUserLanguage));
            return returnMessage;
        }
    }

    public static ReturnMessage<List<RoleUseCaseAuthorization>> mountLocalObjectWithRoleUseCaseAuthorizationListValue(
            SoapReturnMessageWithListValue rmDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedLanguages) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<RoleUseCaseAuthorization>> returnMessage = createInitialReturnMessage(rmDTO);
            if (rmDTO.getValue() != null) {
                returnMessage.setValue(RoleUseCaseAuthorizationListMounter
                        .mountLocalObjectList(rmDTO.getValue(),
                                preferredUserLanguage, supportedLanguages));
            }
            return returnMessage;
        }
    }

    public static ReturnMessage<List<UserRoleAuthorization>> mountLocalObjectWithUserRoleAuthorizationListValue(
            SoapReturnMessageWithListValue rmDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedLanguages) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<UserRoleAuthorization>> returnMessage = createInitialReturnMessage(rmDTO);
            if (rmDTO.getValue() != null) {
                returnMessage.setValue(UserRoleAuthorizationListMounter
                        .mountLocalObjectList(rmDTO.getValue(),
                                preferredUserLanguage, supportedLanguages));
            }
            return returnMessage;
        }
    }

    public static ReturnMessage<Map<String, ResourceAuthorizationMapItem>> mountLocalObjectWithResourceAuthorizationsMapValue(
            SoapReturnMessageWithListValue srmwlvDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (srmwlvDTO == null) {
            return null;
        } else {
            ReturnMessage<Map<String, ResourceAuthorizationMapItem>> returnMessage = createInitialReturnMessage(srmwlvDTO);

            if (srmwlvDTO.getValue() != null) {
                returnMessage.setValue(ResourceAuthorizationsMapMounter
                        .mountLocalObjectMap(srmwlvDTO.getValue(),
                                preferredUserLanguage,
                                supportedApplicationLanguages));
            } else if (srmwlvDTO.getExceptionInfo() == null) {
                returnMessage
                        .setValue(new HashMap<String, ResourceAuthorizationMapItem>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<ApplicationEnvironment>> mountLocalObjectWithApplicationEnvironmentListValue(
            SoapReturnMessageWithListValue srmwlvDTO, Locale preferredUserLanguage) {
        if (srmwlvDTO == null) {
            return null;
        } else {
            ReturnMessage<List<ApplicationEnvironment>> returnMessage = createInitialReturnMessage(srmwlvDTO);

            if (srmwlvDTO.getValue() != null) {
                returnMessage.setValue(ApplicationEnvironmentListMounter.mountLocalObjectList(
                        srmwlvDTO.getValue(), preferredUserLanguage));
            } else if (srmwlvDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<ApplicationEnvironment>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<RoleType>> mountLocalObjectWithRoleTypeListValue(
            SoapReturnMessageWithListValue srmwlvDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedLanguages) {
        if (srmwlvDTO == null) {
            return null;
        } else {
            ReturnMessage<List<RoleType>> returnMessage = createInitialReturnMessage(srmwlvDTO);

            if (srmwlvDTO.getValue() != null) {
                returnMessage.setValue(RoleTypeListMounter
                        .mountLocalObjectList(srmwlvDTO.getValue(),
                                preferredUserLanguage, supportedLanguages));
            } else if (srmwlvDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<RoleType>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<ResourceType>> mountLocalObjectWithResourceTypeListValue(
            SoapReturnMessageWithListValue srmwlvDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedLanguages) {
        if (srmwlvDTO == null) {
            return null;
        } else {
            ReturnMessage<List<ResourceType>> returnMessage = createInitialReturnMessage(srmwlvDTO);

            if (srmwlvDTO.getValue() != null) {
                returnMessage.setValue(ResourceTypeListMounter
                        .mountLocalObjectList(srmwlvDTO.getValue(),
                                preferredUserLanguage, supportedLanguages));
            } else if (srmwlvDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<ResourceType>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<EnvironmentAdministrationAuthorization>> mountLocalObjectWithEnvironmentAdministrationAuthorizationListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<EnvironmentAdministrationAuthorization>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage
                        .setValue(EnvironmentAdministrationAuthorizationListMounter
                                .mountLocalObjectList(soapReturnMessageWithListValueDTO
                                        .getValue()));
            }

            return returnMessage;
        }
    }

    /**
     * Monta uma mensagem de retorno com valor de autorizao de administrao
     * de ambiente a partir de uma mensagem de retorno SOAP.
     * 
     * @param soapReturnMessageValueDTO
     *            Mensagem de retorno SOAP.
     * @return Mensagem de retorno com valor de autorizao de administrao de
     *         ambiente.
     */
    public static ReturnMessage<EnvironmentAdministrationAuthorization> mountLocalObjectWithEnvironmentAdministrationAuthorizationValue(
            SoapReturnMessage soapReturnMessageValueDTO) {
        if (soapReturnMessageValueDTO == null) {
            return null;
        } else {
            ReturnMessage<EnvironmentAdministrationAuthorization> returnMessage = createInitialReturnMessage(soapReturnMessageValueDTO);
            EnvironmentAdministrationAuthorizationDTO envAdmAuthoDTO = (EnvironmentAdministrationAuthorizationDTO) soapReturnMessageValueDTO
                    .getValue();
            returnMessage
                    .setValue(EnvironmentAdministrationAuthorizationMounter
                            .mountLocalObject(envAdmAuthoDTO));
            return returnMessage;
        }
    }

    public static ReturnMessage<List<UserInactivation>> mountLocalObjectWithUserInactiovationListValue(
            SoapReturnMessageWithListValue srmwlvDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedLanguages) {
        if (srmwlvDTO == null) {
            return null;
        } else {
            ReturnMessage<List<UserInactivation>> returnMessage = createInitialReturnMessage(srmwlvDTO);

            if (srmwlvDTO.getValue() != null) {
                returnMessage.setValue(UserInactivationListMounter
                        .mountLocalObjectList(srmwlvDTO.getValue(),
                                preferredUserLanguage, supportedLanguages));
            } else if (srmwlvDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<UserInactivation>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<UserInactivation> mountLocalObjectWithUserInactivationValue(
            SoapReturnMessage rmDTO, Locale cultureInfo,
            List<SupportedLanguage> iList) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<UserInactivation> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                UserInactivationDTO userInactivationDTO = (UserInactivationDTO) rmDTO
                        .getValue();
                returnMessage.setValue(UserInactivationMounter
                        .mountLocalObject(userInactivationDTO, cultureInfo,
                                iList));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<UserGroup> mountLocalObjectWithUserGroupValue(SoapReturnMessage rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<UserGroup> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                UserGroupDTO userGroupDTO = (UserGroupDTO)rmDTO.getValue();
                returnMessage.setValue(UserGroupMounter.mountLocalObject(userGroupDTO, preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<UserGroup>> mountLocalObjectWithUserGroupListValue(SoapReturnMessageWithListValue rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
            if (rmDTO == null) { return null; }
            else {
                ReturnMessage<List<UserGroup>> returnMessage = createInitialReturnMessage(rmDTO);

                if (rmDTO.getValue() != null) {
                    returnMessage.setValue(UserGroupListMounter.mountLocalObject(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
                }

                return returnMessage;
            }
        }
    
    public static ReturnMessage<List<UserGroupMembership>> mountLocalObjectWithUserGroupAuthorizationListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (soapReturnMessageWithListValueDTO == null) {
            return null;
        } else {
            ReturnMessage<List<UserGroupMembership>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(UserGroupMembershipListMounter
                        .mountLocalObjectList(soapReturnMessageWithListValueDTO
                                .getValue(), preferredUserLanguage,
                                supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<UserGroupRoleAuthorization>> mountLocalObjectWithUserGroupRoleAuthorizationListValue(
            SoapReturnMessageWithListValue rmDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<UserGroupRoleAuthorization>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(UserGroupRoleAuthorizationListMounter.mountLocalObjectList(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }
            else if (rmDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<UserGroupRoleAuthorization>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<Information> mountLocalObjectWithInformationValue(
            SoapReturnMessage returnMessageDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (returnMessageDTO == null) { return null; }
        else {
            ReturnMessage<Information> returnMessage = createInitialReturnMessage(returnMessageDTO);

            if (returnMessageDTO.getValue() != null) {
                InformationDTO informationDTO = (InformationDTO)returnMessageDTO.getValue();
                returnMessage.setValue(InformationMounter.mountLocalObject(informationDTO, 
                        preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<Information>> mountLocalObjectWithInformationListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (soapReturnMessageWithListValueDTO == null) { return null; }
        else {
            ReturnMessage<List<Information>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(InformationListMounter.mountLocalObjectList(
                        soapReturnMessageWithListValueDTO.getValue(),
                        preferredUserLanguage, supportedApplicationLanguages));
            }
            else if (soapReturnMessageWithListValueDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<Information>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<InformationSharingType>> mountLocalObjectWithInformationSharingTypeListValue(
            SoapReturnMessageWithListValue srmwlvDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedLanguages) {

        if (srmwlvDTO == null) { return null; }
        else {
            ReturnMessage<List<InformationSharingType>> returnMessage = createInitialReturnMessage(srmwlvDTO);

            if (srmwlvDTO.getValue() != null) {
                returnMessage.setValue(InformationSharingTypeListMounter.mountLocalObjectList(
                        srmwlvDTO.getValue(), preferredUserLanguage, supportedLanguages));
            }
            else if (srmwlvDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<InformationSharingType>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<InformationValue> mountLocalObjectWithInformationValueValue(
            SoapReturnMessage returnMessageDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (returnMessageDTO == null) { return null; }
        else {
            ReturnMessage<InformationValue> returnMessage = createInitialReturnMessage(returnMessageDTO);

            if (returnMessageDTO.getValue() != null) {
                InformationValueDTO informationValueDTO = (InformationValueDTO)returnMessageDTO.getValue();
                returnMessage.setValue(InformationValueMounter.mountLocalObject(informationValueDTO, preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<InformationValue>> mountLocalObjectWithInformationValueListValue(
            SoapReturnMessageWithListValue soapReturnMessageWithListValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (soapReturnMessageWithListValueDTO == null) { return null; }
        else {
            ReturnMessage<List<InformationValue>> returnMessage = createInitialReturnMessage(soapReturnMessageWithListValueDTO);

            if (soapReturnMessageWithListValueDTO.getValue() != null) {
                returnMessage.setValue(InformationValueListMounter.mountLocalObjectList(soapReturnMessageWithListValueDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }
            else if (soapReturnMessageWithListValueDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<InformationValue>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<InformationValueClassification>> mountLocalObjectWithInformationValueClassificationListValue(
            SoapReturnMessageWithListValue srmwlvDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedLanguages) {

        if (srmwlvDTO == null) { return null; }
        else {
            ReturnMessage<List<InformationValueClassification>> returnMessage = createInitialReturnMessage(srmwlvDTO);

            if (srmwlvDTO.getValue() != null) {
                returnMessage.setValue(InformationValueClassificationListMounter.
                    mountLocalObjectList(srmwlvDTO.getValue(), preferredUserLanguage, supportedLanguages));
            }
            else if (srmwlvDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<InformationValueClassification>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<RoleInformationValueAuthorization>> mountLocalObjectWithRoleInformationValueAuthorizationListValue(
            SoapReturnMessageWithListValue rmDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<RoleInformationValueAuthorization>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(RoleInformationValueAuthorizationListMounter.mountLocalObjectList(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }
            else if (rmDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<RoleInformationValueAuthorization>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<UserInformationValueAuthorization>> mountLocalObjectWithUserInformationValueAuthorizationListValue(
            SoapReturnMessageWithListValue rmDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<UserInformationValueAuthorization>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null)
            {
                returnMessage.setValue(UserInformationValueAuthorizationListMounter
                        .mountLocalObjectList(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }
            else if (rmDTO.getExceptionInfo() == null)
            {
                returnMessage.setValue(new ArrayList<UserInformationValueAuthorization>());
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<List<UserGroupInformationValueAuthorization>> mountLocalObjectWithUserGroupInformationValueAuthorizationListValue(
            SoapReturnMessageWithListValue rmDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<UserGroupInformationValueAuthorization>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null)
            {
                returnMessage.setValue(UserGroupInformationValueAuthorizationListMounter
                        .mountLocalObjectList(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }
            else if (rmDTO.getExceptionInfo() == null)
            {
                returnMessage.setValue(new ArrayList<UserGroupInformationValueAuthorization>());
            }

            return returnMessage;
        }
    }
    
    /**
     * Monta uma mensagem de retorno com a lista de autorizaes de valores de informao para grupo corporativo a partir da mensagem SOAP
     * 
     * @param rmDTO Mensagem SOAP.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Mensagem de retorno com a lista de autorizaes de valores de informao para grupo corporativo.
     */
    public static ReturnMessage<List<EnterpriseGroupInformationValueAuthorization>> mountLocalObjectWithEnterpriseGroupInformationValueAuthorizationListValue(
            SoapReturnMessageWithListValue rmDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<EnterpriseGroupInformationValueAuthorization>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage
                        .setValue(EnterpriseGroupInformationValueAuthorizationListMounter
                                .mountLocalObjectList(rmDTO.getValue(),
                                        preferredUserLanguage,
                                        supportedApplicationLanguages));
            } else if (rmDTO.getExceptionInfo() == null) {
                returnMessage
                        .setValue(new ArrayList<EnterpriseGroupInformationValueAuthorization>());
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<EnterpriseGroup> mountLocalObjectWithEnterpriseGroupValue(SoapReturnMessage rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<EnterpriseGroup> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                EnterpriseGroupDTO enterpriseGroupDTO = (EnterpriseGroupDTO)rmDTO.getValue();
                returnMessage.setValue(EnterpriseGroupMounter.mountLocalObject(enterpriseGroupDTO, preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<List<EnterpriseGroup>> mountLocalObjectWithEnterpriseGroupListValue(SoapReturnMessageWithListValue rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<EnterpriseGroup>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(EnterpriseGroupListMounter.mountLocalObject(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }
    
    /**
     * Monta uma mensagem de retorno com a lista de autorizaes de papis para grupo corporativo a partir da mensagem SOAP
     * 
     * @param srmwlvDTO Mensagem SOAP.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Mensagem de retorno com a lista de autorizaes de papis para grupo corporativo.
     */
    public static ReturnMessage<List<EnterpriseGroupRoleAuthorization>> mountLocalObjectWithEnterpriseGroupRoleAuthorizationListValue(
            SoapReturnMessageWithListValue srmwlvDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (srmwlvDTO == null) { return null; }
        else {
            ReturnMessage<List<EnterpriseGroupRoleAuthorization>> returnMessage = createInitialReturnMessage(srmwlvDTO);

            if (srmwlvDTO.getValue() != null) {
                returnMessage.setValue(EnterpriseGroupRoleAuthorizationListMounter.mountLocalObjectList(srmwlvDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }
            else if (srmwlvDTO.getExceptionInfo() == null) {
                returnMessage.setValue(new ArrayList<EnterpriseGroupRoleAuthorization>());
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<Area> mountLocalObjectWithAreaValue(SoapReturnMessage rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<Area> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                AreaDTO areaDTO = (AreaDTO)rmDTO.getValue();
                returnMessage.setValue(AreaMounter.mountLocalObject(areaDTO, preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<List<Area>> mountLocalObjectWithAreaListValue(SoapReturnMessageWithListValue rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<Area>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(AreaListMounter.mountLocalObject(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<AreaManagementAuthorization> mountLocalObjectWithAreaManagementAuthorizationValue(SoapReturnMessage rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<AreaManagementAuthorization> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
            	AreaManagementAuthorizationDTO areaMngAuthDTO = (AreaManagementAuthorizationDTO)rmDTO.getValue();
                returnMessage.setValue(AreaManagementAuthorizationMounter.mountLocalObject(areaMngAuthDTO, preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }
    
    public static ReturnMessage<List<AreaManagementAuthorization>> mountLocalObjectWithAreaManagementAuthorizationListValue(SoapReturnMessageWithListValue rmDTO,
            Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<AreaManagementAuthorization>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(AreaManagementAuthorizationListMounter.mountLocalObject(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<IContext>> mountLocalObjectWithContextListValue(SoapReturnMessageWithListValue rmDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<IContext>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(ContextMounter.mountLocalObject(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }

    public static ReturnMessage<List<ContextValueSet>> mountLocalObjectWithContextValueSetListValue(SoapReturnMessageWithListValue rmDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (rmDTO == null) { return null; }
        else {
            ReturnMessage<List<ContextValueSet>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(ContextValueSetMounter.mountLocalList(rmDTO.getValue(), preferredUserLanguage, supportedApplicationLanguages));
            }

            return returnMessage;
        }
    }


    /**
     * Monta uma mensagem de retorno com lista de logs de autenticacao a partir de uma
     * mensagem de retorno com lista de logs de autenticacao de tranferncia SOAP.
     *
     * @param rmDTO
     *            Mensagem de retorno com lista de logs de autenticacao de tranferncia SOAP
     * @return Mensagem de retorno com lista de logs de autenticacao.
     */
    public static ReturnMessage<List<LogAuthentication>> mountLocalObjectWithLogAuthenticationListValue(
            SoapReturnMessageWithListValue rmDTO) {
        if (rmDTO == null) {
            return null;
        } else {
            ReturnMessage<List<LogAuthentication>> returnMessage = createInitialReturnMessage(rmDTO);

            if (rmDTO.getValue() != null) {
                returnMessage.setValue(LogAuthenticationListMounter.mountLocalObject(rmDTO.getValue()));
            }

            return returnMessage;
        }
    }


}

