/*
 * RoleMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.RoleInformationContext;
import br.com.petrobras.security.model.IRoleContext;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.List;
import java.util.Locale;

/**
 * Montador de papis.
 *
 */
public class RoleMounter {

    /**
     * Monta um papel a partir de um papel DTO.
     * 
     * @param roleDTO Papel DTO
     * @return Papel.
     */
    public static Role mountLocalObject(RoleDTO roleDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (roleDTO == null) {
            return null;
        } else {
            Role role = new Role();

            // Montagem simples.
            role.setUid(roleDTO.getUid());
            role.setId(roleDTO.getId());
            role.setEnabled(roleDTO.isEnabled());
            role.setCreationDate(DateMounter.mountLocalObject(roleDTO.getCreationDate()));

            // Montagem complexa.
            role.setExpiration(ExpirationMounter.mountLocalObject(roleDTO.getExpiration()));
            role.setType(RoleTypeMounter.mountLocalObject(roleDTO.getType(), preferredUserLanguage, supportedApplicationLanguages));
            role.setArea(AreaMounter.mountLocalObject(roleDTO.getArea(), preferredUserLanguage, supportedApplicationLanguages));
            role.setApplicationEnvironment(ApplicationEnvironmentMounter.mountLocalObject(roleDTO.getApplicationEnvironment(), preferredUserLanguage));

            role.setContexts(RoleContextListMounter.mountLocalObjectList(roleDTO.getContexts(), role, preferredUserLanguage, supportedApplicationLanguages));

            // Montagem da I18n.
            role.setNameTranslations(I18nStringMounter.mountModelObject(roleDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            role.setDescriptionTranslations(I18nStringMounter.mountModelObject(roleDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));

            return role;
        }
    }

    /**
     * Monta um papel de transferncia a partir de um papel.
     * 
     * @param role
     *            Papel.
     * @return Papel de transferncia.
     */
    public static RoleDTO mountTransferObject(Role role, List<SupportedLanguage> supportedApplicationLanguages) {
        if (role == null) {
            return null;
        } else {

            if (role.getNameTranslations() == null
                    || role.getNameTranslations().getCount() < 1) {
                throw new IllegalArgumentException(
                        "A lista de tradues de nome do papel est nula ou vazia.");
            }

            if (role.getDescriptionTranslations() == null
                    || role.getDescriptionTranslations().getCount() < 1) {
                throw new IllegalArgumentException("A lista de tradues de descrio do papel est nula ou vazia.");
            }

            RoleDTO roleDTO = new RoleDTO();

            // Montagem simples.
            roleDTO.setUid(role.getUid());
            roleDTO.setId(role.getId());
            roleDTO.setEnabled(role.isEnabled());

            try {
                roleDTO.setCreationDate(DateMounter.mountTransferObject(role
                        .getCreationDate()));
            } catch (DatatypeConfigurationException dtce) {
                throw new InvalidOperationException("No foi possvel converter a data de cadastro do papel para enviar ao servio. "+ dtce.getMessage());
            }

            // Montagem complexa.
            roleDTO.setExpiration(ExpirationMounter.mountTransferObject(role .getExpiration()));
            roleDTO.setType(RoleTypeMounter.mountTransferObject(role.getType()));
            roleDTO.setArea(AreaMounter.mountTransferObject(role.getArea(), supportedApplicationLanguages));
            roleDTO.setApplicationEnvironment(ApplicationEnvironmentMounter.mountTransferObject(role.getApplicationEnvironment()));

            if (role.getContexts() != null) {
                for (IRoleContext context : role.getContexts()) {
                    if (context instanceof RoleInformationContext) {
                        roleDTO.getContexts().add(RoleInformationContextMounter.mountTransferObject((RoleInformationContext)context));
                    }
                    else {
                        throw new UnsupportedOperationException("Tipo de contexto no  suportado. Talvez seja preciso atualizar a API.");
                    }
                }
            }

            // Montagem da I18n.
            roleDTO.setNameTranslations(I18nStringMounter.mountTransferObject(role.getNameTranslations(), supportedApplicationLanguages));
            roleDTO.setDescriptionTranslations(I18nStringMounter.mountTransferObject(role.getDescriptionTranslations(), supportedApplicationLanguages));

            return roleDTO;
        }
    }

}

