/*
 * UserGroupMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.UserGroup;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.UserGroupDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.List;
import java.util.Locale;

public class UserGroupMounter {

	public static UserGroupDTO mountTransferObject(UserGroup userGroup, List<SupportedLanguage> supportedApplicationLanguages) {
		
        UserGroupDTO dto = new UserGroupDTO();
        dto.setUid(userGroup.getUid());
        dto.setId(userGroup.getId());
        dto.setNameTranslations(I18nStringMounter.mountTransferObject(userGroup.getNameTranslations(), supportedApplicationLanguages));
        dto.setDescriptionTranslations(I18nStringMounter.mountTransferObject(userGroup.getDescriptionTranslations(), supportedApplicationLanguages));
        dto.setEnabled(userGroup.isEnabled());
        dto.setApplicationEnvironment(ApplicationEnvironmentMounter.mountTransferObject(userGroup.getApplicationEnvironment()));
        dto.setArea(AreaMounter.mountTransferObject(userGroup.getArea(), null));
        dto.setExpiration(ExpirationMounter.mountTransferObject(userGroup.getExpiration()));
        try {
        	dto.setCreationDate (DateMounter.mountTransferObject(userGroup.getCreationDate()));
        } catch(DatatypeConfigurationException dce) {
        	userGroup.setCreationDate(null);
        }
        
        return dto;
    }
	
	public static UserGroup mountLocalObject(UserGroupDTO dto, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        UserGroup model = new UserGroup();
        model.setUid(dto.getUid());
        model.setId(dto.getId());
        model.setNameTranslations(I18nStringMounter.mountModelObject(dto.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
        model.setDescriptionTranslations(I18nStringMounter.mountModelObject(dto.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));
        model.setEnabled(dto.isEnabled());
        model.setApplicationEnvironment(ApplicationEnvironmentMounter.mountLocalObject(dto.getApplicationEnvironment(), preferredUserLanguage));
        model.setArea(AreaMounter.mountLocalObject(dto.getArea(), preferredUserLanguage, supportedApplicationLanguages));
        model.setExpiration(ExpirationMounter.mountLocalObject(dto.getExpiration()));
        model.setCreationDate(DateMounter.mountLocalObject(dto.getCreationDate()));
        
        return model;
    }
}
