/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.FindAllResourceGroupAuthorizationsOfRoleCommand;
import br.com.petrobras.security.command.management.authorization.FindAllRolesWithAuthorizationInResourceGroupCommand;
import br.com.petrobras.security.command.management.authorization.GrantResourceGroupAuthorizationToRoleCommand;
import br.com.petrobras.security.command.management.authorization.RevokeResourceGroupAuthorizationFromRoleCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IRoleResourceGroupAuthorizationManager;
import br.com.petrobras.security.model.ResourceGroup;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.authorization.access.RoleResourceGroupAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class RoleResourceGroupAuthorizationManagerCoreImpl
implements IRoleResourceGroupAuthorizationManager {
    public List<RoleResourceGroupAuthorization> findAll(Role role) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        return this.findAll(role.getId());
    }

    public List<RoleResourceGroupAuthorization> findAll(String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllResourceGroupAuthorizationsOfRoleCommand cmd = ICommandIdentifier.getInstance().getFindAllResourceGroupAuthorizationsOfRoleCommand();
        cmd.setRoleIdArg(roleId);
        return (List)cmd.execute();
    }

    public List<RoleResourceGroupAuthorization> findAllInResourceGroup(ResourceGroup resourceGroup) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resourceGroup);
        return this.findAllInResourceGroup(resourceGroup.getId());
    }

    public List<RoleResourceGroupAuthorization> findAllInResourceGroup(String resourceGroupId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllRolesWithAuthorizationInResourceGroupCommand cmd = ICommandIdentifier.getInstance().getFindAllRolesWithAuthorizationInResourceGroupCommand();
        cmd.setResourceGroupIdArg(resourceGroupId);
        return (List)cmd.execute();
    }

    public void grant(ResourceGroup resourceGroup, Role role) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resourceGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.grant(resourceGroup.getId(), role.getId());
    }

    public void grant(String resourceGroupId, String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        GrantResourceGroupAuthorizationToRoleCommand cmd = ICommandIdentifier.getInstance().getGrantResourceGroupAuthorizationToRoleCommand();
        cmd.setResourceGroupIdArg(resourceGroupId);
        cmd.setRoleIdArg(roleId);
        cmd.execute();
    }

    public void revoke(ResourceGroup resourceGroup, Role role) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resourceGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.revoke(resourceGroup.getId(), role.getId());
    }

    public void revoke(String resourceGroupId, String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        RevokeResourceGroupAuthorizationFromRoleCommand cmd = ICommandIdentifier.getInstance().getRevokeResourceGroupAuthorizationFromRoleCommand();
        cmd.setResourceGroupIdArg(resourceGroupId);
        cmd.setRoleIdArg(roleId);
        cmd.execute();
    }
}

