/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.basic;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.basic.externaluser.FindAllApplicationEnvironmentExternalUsersCommand;
import br.com.petrobras.security.command.management.basic.externaluser.FindAllExternalUsersByDocumentNumberCommand;
import br.com.petrobras.security.command.management.basic.externaluser.FindAllExternalUsersByTextFilterCommand;
import br.com.petrobras.security.command.management.basic.externaluser.FindAllExternalUsersCommand;
import br.com.petrobras.security.command.management.basic.externaluser.FindExternalUserByLoginCommand;
import br.com.petrobras.security.command.management.basic.externaluser.GenerateNewPasswordToExternalUserCommand;
import br.com.petrobras.security.command.management.basic.externaluser.RemoveExternalUserCommand;
import br.com.petrobras.security.command.management.basic.externaluser.SaveExternalUserCommand;
import br.com.petrobras.security.command.management.basic.externaluser.UpdateExternalUserCommand;
import br.com.petrobras.security.command.management.basic.externaluser.UpdatePasswordFromExternalUserCommand;
import br.com.petrobras.security.configuration.SecuritySettings;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidCredentialsException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.basic.IExternalUserManager;
import br.com.petrobras.security.model.ExternalUser;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class ExternalUserManagerCoreImpl
implements IExternalUserManager {
    public ExternalUser find(String userLogin) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindExternalUserByLoginCommand cmd = ICommandIdentifier.getInstance().getFindExternalUserByLoginCommand();
        cmd.setUserLoginArg(userLogin);
        return (ExternalUser)cmd.execute();
    }

    public List<ExternalUser> findAll() throws PermissionDeniedException, SecurityException {
        FindAllExternalUsersCommand cmd = ICommandIdentifier.getInstance().getFindAllExternalUsersCommand();
        return (List)cmd.execute();
    }

    public List<ExternalUser> findAllInApplicationEnvironment() throws PermissionDeniedException, SecurityException {
        FindAllApplicationEnvironmentExternalUsersCommand cmd = ICommandIdentifier.getInstance().getFindAllApplicationEnvironmentExternalUsersCommand();
        return (List)cmd.execute();
    }

    public List<ExternalUser> findAllByDocumentNumber(String userDocumentNumber) throws PermissionDeniedException, InvalidArgumentException, SecurityException {
        FindAllExternalUsersByDocumentNumberCommand cmd = ICommandIdentifier.getInstance().getFindAllExternalUsersByDocumentNumberCommand();
        cmd.setUserDocumentNumberArg(userDocumentNumber);
        return (List)cmd.execute();
    }

    public List<ExternalUser> findAllByTextFilter(String textFilter) throws PermissionDeniedException, InvalidArgumentException, SecurityException {
        FindAllExternalUsersByTextFilterCommand cmd = ICommandIdentifier.getInstance().getFindAllExternalUsersByTextFilterCommand();
        cmd.setTextFilterArg(textFilter);
        return (List)cmd.execute();
    }

    public void save(ExternalUser externalUser) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, SecurityException {
        SaveExternalUserCommand cmd = ICommandIdentifier.getInstance().getSaveExternalUserCommand();
        cmd.setExternalUserArg(externalUser);
        cmd.execute();
    }

    public void update(ExternalUser externalUser) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, SecurityException {
        UpdateExternalUserCommand cmd = ICommandIdentifier.getInstance().getUpdateExternalUserCommand();
        cmd.setExternalUserArg(externalUser);
        cmd.execute();
    }

    public void remove(ExternalUser externalUser) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)externalUser);
        this.remove(externalUser.getLogin());
    }

    public void remove(String userLogin) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, SecurityException {
        RemoveExternalUserCommand cmd = ICommandIdentifier.getInstance().getRemoveExternalUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.execute();
    }

    public void updatePassword(String externalUserLogin, String oldPassword, String newPassword) throws InvalidCredentialsException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        this.updatePassword(SecuritySettings.getRegionalId(), SecuritySettings.getEnvironmentId(), SecuritySettings.getApplicationCatalogId(), SecuritySettings.getApplicationPassword(), externalUserLogin, oldPassword, newPassword);
    }

    public void updatePassword(String regionalId, String environmentId, String applicationCatalogId, String applicationPassword, String externalUserLogin, String oldPassword, String newPassword) throws InvalidCredentialsException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        UpdatePasswordFromExternalUserCommand cmd = ICommandIdentifier.getInstance().getUpdatePasswordFromExternalUserCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setEnvironmentIdArg(environmentId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setApplicationPasswordArg(applicationPassword);
        cmd.setExternalUserLoginArg(externalUserLogin);
        cmd.setOldPasswordArg(oldPassword);
        cmd.setNewPasswordArg(newPassword);
        cmd.execute();
    }

    public void generateNewPassword(String externalUserLogin) throws InvalidArgumentException, ObjectNotFoundException, SecurityException {
        GenerateNewPasswordToExternalUserCommand cmd = ICommandIdentifier.getInstance().getGenerateNewPasswordToExternalUserCommand();
        cmd.setExternalUserLoginArg(externalUserLogin);
        cmd.execute();
    }

    public void generateNewPassword(ExternalUser externalUser) throws InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)externalUser);
        this.generateNewPassword(externalUser.getLogin());
    }
}

