/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.command.authentication.userauthenticator;

import br.com.petrobras.security.command.AbstractCommand;
import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.authentication.IUserAuthenticatorConsumer;
import br.com.petrobras.security.context.state.UserContextState;
import br.com.petrobras.security.exception.ExceptionHandler;
import br.com.petrobras.security.exception.ExceptionInfo;
import br.com.petrobras.security.exception.InvalidCredentialsException;
import br.com.petrobras.security.exception.InvalidOperationException;

public class UserLogoffCommand
extends AbstractCommand<Boolean> {
    private IUserAuthenticatorConsumer userAuthenticatorConsumer;

    public IUserAuthenticatorConsumer getUserAuthenticatorConsumer() {
        return this.userAuthenticatorConsumer;
    }

    public void setUserAuthenticatorConsumer(IUserAuthenticatorConsumer userAuthenticatorConsumer) {
        this.userAuthenticatorConsumer = userAuthenticatorConsumer;
    }

    @Override
    protected void executeConsume() {
        MessageHeader mh = new MessageHeader(super.getUserContextIdentifier().getCurrentUserContext());
        super.setReturnMessage(this.getUserAuthenticatorConsumer().logoff(mh));
    }

    @Override
    protected void preExecute() {
        if (this.getUserContextIdentifier().getCurrentUserContext().getState() == UserContextState.NOT_LOGGED) {
            throw new InvalidOperationException("O contexto de seguran\u00e7a atual do usu\u00e1rio n\u00e3o est\u00e1 logado.");
        }
    }

    @Override
    protected void posExecute() {
        if (this.getReturnMessage().getExceptionInfo() != null) {
            try {
                ExceptionHandler.handle((ExceptionInfo)this.getReturnMessage().getExceptionInfo());
            }
            catch (InvalidCredentialsException ice) {
                this.getUserContextIdentifier().getCurrentUserContext().logoff();
                throw ice;
            }
        }
        this.getUserContextIdentifier().getCurrentUserContext().logoff();
    }
}

