/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.command.authorization.basic;

import br.com.petrobras.security.command.AbstractCommand;
import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.authorization.IApplicationEnvironmentAuthorizerConsumer;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class FindAllUserApplicationEnvironmentsCommand
extends AbstractCommand<List<ApplicationEnvironment>> {
    private IApplicationEnvironmentAuthorizerConsumer applicationEnvironmentAuthorizerConsumer;
    private String userLoginArg;
    private String regionalIdArg;
    private String environmentIdArg;

    @Override
    protected void executeConsume() {
        MessageHeader mh = super.getMessageHeader();
        String userLogin = this.getUserLoginArg();
        if (Validator.isNullOrEmpty((String)userLogin)) {
            userLogin = super.getUserContextIdentifier().getCurrentUserContext().getLoggedUser().getLogin();
        }
        super.setReturnMessage(this.getApplicationEnvironmentAuthorizerConsumer().findAll(mh, userLogin, this.getRegionalIdArg(), this.getEnvironmentIdArg()));
    }

    public void setApplicationEnvironmentAuthorizerConsumer(IApplicationEnvironmentAuthorizerConsumer applicationEnvironmentAuthorizerConsumer) {
        this.applicationEnvironmentAuthorizerConsumer = applicationEnvironmentAuthorizerConsumer;
    }

    public IApplicationEnvironmentAuthorizerConsumer getApplicationEnvironmentAuthorizerConsumer() {
        return this.applicationEnvironmentAuthorizerConsumer;
    }

    public String getUserLoginArg() {
        return this.userLoginArg;
    }

    public void setUserLoginArg(String userLoginArg) {
        this.userLoginArg = userLoginArg;
    }

    public String getRegionalIdArg() {
        return this.regionalIdArg;
    }

    public void setRegionalIdArg(String regionalIdArg) {
        this.regionalIdArg = regionalIdArg;
    }

    public String getEnvironmentIdArg() {
        return this.environmentIdArg;
    }

    public void setEnvironmentIdArg(String environmentIdArg) {
        this.environmentIdArg = environmentIdArg;
    }
}

