/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.command.management.log;

import br.com.petrobras.security.command.AbstractCommand;
import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.management.log.IAuthenticationLogManagerConsumer;
import br.com.petrobras.security.context.UserContext;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.log.LogAuthentication;
import br.com.petrobras.security.model.util.Period;
import java.util.List;

public class FindAuthenticationLogsCommand
extends AbstractCommand<List<LogAuthentication>> {
    public IAuthenticationLogManagerConsumer authenticationLogManagerConsumer;
    private ApplicationEnvironment appEnvUid;
    private String userLogin;
    private Period period;
    private LogAuthentication.EventType eventType;
    private LogAuthentication.AuthenticationType authenticationType;
    private LogAuthentication.StatusType statusType;

    public IAuthenticationLogManagerConsumer getAuthenticationLogManagerConsumer() {
        return this.authenticationLogManagerConsumer;
    }

    public void setAuthenticationLogManagerConsumer(IAuthenticationLogManagerConsumer authenticationLogManagerConsumer) {
        this.authenticationLogManagerConsumer = authenticationLogManagerConsumer;
    }

    public ApplicationEnvironment getAppEnvUid() {
        return this.appEnvUid;
    }

    public void setAppEnvUid(ApplicationEnvironment appEnvUid) {
        this.appEnvUid = appEnvUid;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public LogAuthentication.EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(LogAuthentication.EventType eventType) {
        this.eventType = eventType;
    }

    public LogAuthentication.AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(LogAuthentication.AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public LogAuthentication.StatusType getStatusType() {
        return this.statusType;
    }

    public void setStatusType(LogAuthentication.StatusType statusType) {
        this.statusType = statusType;
    }

    @Override
    protected void executeConsume() {
        MessageHeader mh = new MessageHeader(super.getUserContextIdentifier().getCurrentUserContext());
        UserContext userContext = this.getUserContextIdentifier().getCurrentUserContext();
        ApplicationEnvironment applicationEnvironment = userContext.getConnectedApplicationEnvironment();
        String regionalId = applicationEnvironment.getEnvironment().getRegional().getId();
        String environmentId = applicationEnvironment.getEnvironment().getId();
        String applicationCatalogId = applicationEnvironment.getApplication().getCatalogId();
        super.setReturnMessage(this.getAuthenticationLogManagerConsumer().findByFilter(mh, regionalId, environmentId, applicationCatalogId, this.getUserLogin(), this.getPeriod(), this.getEventType(), this.getAuthenticationType(), this.getStatusType()));
    }
}

