/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.model;

import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.model.IContext;
import br.com.petrobras.security.model.IRoleContext;
import br.com.petrobras.security.model.Information;
import br.com.petrobras.security.model.RoleInformationContext;
import br.com.petrobras.security.model.RoleType;
import br.com.petrobras.security.model.authorization.access.RoleAdministrationAuthorization;
import br.com.petrobras.security.model.authorization.access.RoleResourceAuthorization;
import br.com.petrobras.security.model.i18n.I18nString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Role
implements Serializable {
    private static final long serialVersionUID = -4537963507328888026L;
    private Long uid;
    private String id;
    private I18nString nameTranslations = new I18nString();
    private I18nString descriptionTranslations = new I18nString();
    private boolean enabled;
    private Date creationDate;
    private RoleType type;
    private Area area;
    private Expiration expiration;
    private List<RoleAdministrationAuthorization> administeredRoles = new ArrayList<RoleAdministrationAuthorization>();
    private List<RoleResourceAuthorization> resources = new ArrayList<RoleResourceAuthorization>();
    private List<IRoleContext> contexts = new ArrayList<IRoleContext>();

    public Role() {
    }

    public Role(String id) {
        this.id = id;
    }

    public Role(String id, boolean enabled, RoleType type) {
        this.setId(id);
        this.setEnabled(enabled);
        this.setType(type);
    }

    public Role(String id, String name, String description, RoleType type) {
        this.setId(id);
        this.setName(name);
        this.setDescription(description);
        this.setType(type);
    }

    public Role(String id, String name, String description, boolean enabled, RoleType type) {
        this.setId(id);
        this.setName(name);
        this.setDescription(description);
        this.setEnabled(enabled);
        this.setType(type);
    }

    public Role(String id, I18nString nameTranslations, I18nString descriptionTranslations, boolean enabled, RoleType type) {
        this.setId(id);
        this.setNameTranslations(nameTranslations);
        this.setDescriptionTranslations(descriptionTranslations);
        this.setEnabled(enabled);
        this.setType(type);
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getCreationDate() {
        if (this.creationDate == null) {
            return null;
        }
        return (Date)this.creationDate.clone();
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate == null ? null : (Date)creationDate.clone();
    }

    public RoleType getType() {
        return this.type;
    }

    public void setType(RoleType roleType) {
        this.type = roleType;
    }

    public Expiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Expiration expiration) {
        this.expiration = expiration;
    }

    public ApplicationEnvironment getApplicationEnvironment() {
        if (this.getArea() != null) {
            return this.getArea().getApplicationEnvironment();
        }
        return null;
    }

    public void setApplicationEnvironment(ApplicationEnvironment applicationEnvironment) {
        if (this.getArea() != null) {
            this.getArea().setApplicationEnvironment(applicationEnvironment);
        }
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public List<RoleResourceAuthorization> getResources() {
        return this.resources;
    }

    public void setResources(List<RoleResourceAuthorization> resources) {
        this.resources = resources;
    }

    public List<RoleAdministrationAuthorization> getAdministeredRoles() {
        return this.administeredRoles;
    }

    public void setAdministeredRoles(List<RoleAdministrationAuthorization> administeredRoles) {
        this.administeredRoles = administeredRoles;
    }

    public List<IRoleContext> getContexts() {
        if (this.contexts == null) {
            this.contexts = new ArrayList<IRoleContext>();
        }
        return this.contexts;
    }

    public void setContexts(List<IRoleContext> contexts) {
        this.contexts = contexts;
    }

    public String getName() {
        return this.nameTranslations.get();
    }

    public void setName(String name) {
        this.nameTranslations.set(name);
    }

    public String getDescription() {
        return this.descriptionTranslations.get();
    }

    public void setDescription(String description) {
        this.descriptionTranslations.set(description);
    }

    public I18nString getNameTranslations() {
        return this.nameTranslations;
    }

    public void setNameTranslations(I18nString nameTranslations) {
        this.nameTranslations = nameTranslations;
    }

    public I18nString getDescriptionTranslations() {
        return this.descriptionTranslations;
    }

    public void setDescriptionTranslations(I18nString descriptionTranslations) {
        this.descriptionTranslations = descriptionTranslations;
    }

    public String getName(Locale locale) {
        return this.nameTranslations.get(locale);
    }

    public void setName(Locale locale, String nameTranslation) {
        this.nameTranslations.set(locale, nameTranslation);
    }

    public String getDescription(Locale locale) {
        return this.descriptionTranslations.get(locale);
    }

    public void setDescription(Locale locale, String descriptionTranslation) {
        this.descriptionTranslations.set(locale, descriptionTranslation);
    }

    public void addContext(IContext context) {
        if (!(context instanceof Information)) {
            throw new UnsupportedOperationException("Tipo de contexto n\u00e3o \u00e9 suportado. Talvez seja necess\u00e1rio atualizar a API.");
        }
        RoleInformationContext roleContext = new RoleInformationContext();
        roleContext.setContext(context);
        this.getContexts().add(roleContext);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.uid != null ? this.uid.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        if (this.uid != null && other.uid != null) {
            if (!this.uid.equals(other.uid)) {
                return false;
            }
        } else {
            if (this.id == null ? other.id != null : !this.id.equalsIgnoreCase(other.id)) {
                return false;
            }
            if (this.getArea() == null ? other.getArea() != null : !this.getArea().equals(other.getArea())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "[uid=" + this.uid + "][id=" + this.id + "]";
    }
}

