 /*
 * EnterpriseGroupRoleAuthorizationListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.authorization.access.EnterpriseGroupRoleAuthorization;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupRoleAuthorizationDTO;

 import java.util.ArrayList;
 import java.util.List;
 import java.util.Locale;

/**
 * Montador de lista de autorizaes de papel para grupo corporativo.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class EnterpriseGroupRoleAuthorizationListMounter {

    /**
     * Monta uma lista de autorizaes de papel para grupo corporativo a partir de uma
     * autorizao de papel para grupo corporativo de transferncia.
     * 
     * @param enterpriseGroupRoleAuthorizationListDTO Lista de autorizaes de papel para grupo corporativo de transferncia.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Lista de autorizaes de papel para grupo corporativo.
     */
    public static List<EnterpriseGroupRoleAuthorization> mountLocalObjectList(
            List<Object> enterpriseGroupRoleAuthorizationListDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (enterpriseGroupRoleAuthorizationListDTO == null) { return null; }
        else {
            List<EnterpriseGroupRoleAuthorization> enterpriseGroupRoleAuthorizationList = new ArrayList<EnterpriseGroupRoleAuthorization>();

            for (Object objectEnterpriseGroupRoleAuthorizationDTO : enterpriseGroupRoleAuthorizationListDTO) {
                EnterpriseGroupRoleAuthorizationDTO enterpriseGroupRoleAuthorizationDTO = (EnterpriseGroupRoleAuthorizationDTO) objectEnterpriseGroupRoleAuthorizationDTO;
                enterpriseGroupRoleAuthorizationList
                        .add(EnterpriseGroupRoleAuthorizationMounter
                                .mountLocalObject(
                                        enterpriseGroupRoleAuthorizationDTO,
                                        preferredUserLanguage,
                                        supportedApplicationLanguages));
            }

            return enterpriseGroupRoleAuthorizationList;
        }
    }

}
