/*
 * InformationSharingTypeMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.InformationSharingType;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.InformationSharingTypeDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.List;
import java.util.Locale;

/**
 * TODO Comentar
 * 
 * @author UPM7
 *
 */
public class InformationSharingTypeMounter {

    /**
     * @param sharingTypeDTO
     * @param preferredUserLanguage
     * @param supportedApplicationLanguages
     * @return Objeto de modelo.
     */
    public static InformationSharingType mountLocalObject(
            InformationSharingTypeDTO sharingTypeDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        InformationSharingType sharingType = new InformationSharingType();
        
        sharingType.setUid(sharingTypeDTO.getUid());
        sharingType.setId(sharingTypeDTO.getId());
        sharingType.setCreationDate(DateMounter.mountLocalObject(sharingTypeDTO.getCreationDate()));
        
        sharingType.setNameTranslations(I18nStringMounter.mountModelObject(sharingTypeDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
        sharingType.setDescriptionTranslations(I18nStringMounter.mountModelObject(sharingTypeDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));
        
        return sharingType;
    }

    /**
     * @param sharingType
     * @return Objeto de tranferencia.
     */
    public static InformationSharingTypeDTO mountTransferObject(
            InformationSharingType sharingType) {

        InformationSharingTypeDTO sharingTypeDTO = new InformationSharingTypeDTO();
        
        sharingTypeDTO.setUid(sharingType.getUid());
        sharingTypeDTO.setId(sharingType.getId());
        try {
            sharingTypeDTO.setCreationDate(DateMounter.mountTransferObject(sharingType.getCreationDate()));
        } catch (DatatypeConfigurationException e) { /* nao precisa fazer nada */ }
        
        sharingTypeDTO.setNameTranslations(I18nStringMounter.mountTransferObject(sharingType.getNameTranslations()));
        sharingTypeDTO.setDescriptionTranslations(I18nStringMounter.mountTransferObject(sharingType.getDescriptionTranslations()));
        
        return sharingTypeDTO;
    }

}
