/*
 * InformationValueClassificationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.InformationValueClassification;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.InformationValueClassificationDTO;

import java.util.List;
import java.util.Locale;

/**
 *
 * @author UPM7
 */
public class InformationValueClassificationMounter {

    public static InformationValueClassificationDTO mountTransferObject(
            InformationValueClassification classification) {

        if (classification == null) {
            return null;
        } else {

            InformationValueClassificationDTO dto = new InformationValueClassificationDTO();
            dto.setUid(classification.getUid());
            dto.setId(classification.getId());

            dto.setNameTranslations(I18nStringMounter.mountTransferObject(
                    classification.getNameTranslations()));
            dto.setDescriptionTranslations(I18nStringMounter.mountTransferObject(
                    classification.getDescriptionTranslations()));
            return dto;
        }
    }

    public static InformationValueClassification mountLocalObject(
            InformationValueClassificationDTO informationValueClassificationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        if (informationValueClassificationDTO == null) { return null; }
        else {
            InformationValueClassification informationValueClassification = new InformationValueClassification();

            // Montagem simples.
            informationValueClassification.setUid(informationValueClassificationDTO.getUid());

            informationValueClassification.setId(informationValueClassificationDTO.getId());

            // Montagem da I18n.
            informationValueClassification.setNameTranslations(I18nStringMounter.mountModelObject(
                    informationValueClassificationDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            informationValueClassification.setDescriptionTranslations(I18nStringMounter.mountModelObject(
                    informationValueClassificationDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));

            return informationValueClassification;
        }
    }

}
