 /*
 * RoleResourceGroupAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.authorization.access.RoleResourceGroupAuthorization;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.RoleResourceGroupAuthorizationDTO;

 import java.util.List;
 import java.util.Locale;

/**
 * Montador de autoricao de papel em grupo de recurso.
 * 
 * @author Patrezze - YMPD
 * @since 3.0
 * @version 1.0
 *
 */
public class RoleResourceGroupAuthorizationMounter {

    /**
     * Monta um autorizao de papel em grupo de recurso a partir de uma
     * autorizao de papel em grupo de recurso de transferncia.
     * 
     * @param roleResourceGroupAuthorizationDTO Grupo de recurso de transferncia.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Autorizao de papel em grupo de recurso.
     */
    public static RoleResourceGroupAuthorization mountLocalObject(
            RoleResourceGroupAuthorizationDTO roleResourceGroupAuthorizationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (roleResourceGroupAuthorizationDTO == null) {
            return null;
        } else {
            RoleResourceGroupAuthorization roleResourceGroupAuthorization = new RoleResourceGroupAuthorization();

            // Montagem simples.
            roleResourceGroupAuthorization
                    .setUid(roleResourceGroupAuthorizationDTO.getUid());

            // Montagem complexa.
            roleResourceGroupAuthorization.setResourceGroup(ResourceGroupMounter
                    .mountLocalObject(roleResourceGroupAuthorizationDTO
                            .getResourceGroup(), preferredUserLanguage,
                            supportedApplicationLanguages));
            
            roleResourceGroupAuthorization.setRole(RoleMounter
                    .mountLocalObject(roleResourceGroupAuthorizationDTO
                            .getRole(), preferredUserLanguage,
                            supportedApplicationLanguages));

            return roleResourceGroupAuthorization;
        }
    }
    
}
