/*
 * UserGroupRoleAuthorizationListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.access.UserGroupRoleAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.UserGroupRoleAuthorizationDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class UserGroupRoleAuthorizationListMounter {

    public static List<UserGroupRoleAuthorization> mountLocalObjectList(
            List<Object> userGroupRoleListDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        if (userGroupRoleListDTO == null) { return null; }
        else {
            List<UserGroupRoleAuthorization> userGroupRoleAuthorizationList = new ArrayList<UserGroupRoleAuthorization>();

            for (Object objectUserGroupRoleAuthorizationDTO : userGroupRoleListDTO) {
                UserGroupRoleAuthorizationDTO userGroupRoleAuthorizationDTO = (UserGroupRoleAuthorizationDTO)objectUserGroupRoleAuthorizationDTO;
                userGroupRoleAuthorizationList.add(UserGroupRoleAuthorizationMounter.mountLocalObject(userGroupRoleAuthorizationDTO, preferredUserLanguage, supportedApplicationLanguages));
            }

            return userGroupRoleAuthorizationList;
        }
    }

}
