/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.authorization;

import br.com.petrobras.security.authorization.IUseCaseAuthorizer;
import br.com.petrobras.security.command.authorization.configuration.VerifyUserAuthorizationInUseCaseCommand;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.model.UseCase;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.utility.Validator;

public class UseCaseAuthorizerCoreImpl
implements IUseCaseAuthorizer {
    private static final long serialVersionUID = -7004939845618837155L;

    public boolean isAuthorized(String useCaseId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        VerifyUserAuthorizationInUseCaseCommand cmd = ICommandIdentifier.getInstance().getVerifyUserAuthorizationInUseCaseCommand();
        cmd.setUseCaseIdArg(useCaseId);
        return (Boolean)cmd.execute();
    }

    public boolean isAuthorized(String useCaseId, boolean withLog) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        VerifyUserAuthorizationInUseCaseCommand cmd = ICommandIdentifier.getInstance().getVerifyUserAuthorizationInUseCaseCommand();
        cmd.setUseCaseIdArg(useCaseId);
        cmd.setWithLogArg(withLog);
        return (Boolean)cmd.execute();
    }

    public boolean isAuthorized(UseCase useCase) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)useCase);
        return this.isAuthorized(useCase.getId());
    }

    public boolean isAuthorized(UseCase useCase, boolean withLog) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)useCase);
        return this.isAuthorized(useCase.getId(), withLog);
    }

    public boolean isAuthorized(String userLogin, String useCaseId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        VerifyUserAuthorizationInUseCaseCommand cmd = ICommandIdentifier.getInstance().getVerifyUserAuthorizationInUseCaseCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setUseCaseIdArg(useCaseId);
        return (Boolean)cmd.execute();
    }

    public boolean isAuthorized(String userLogin, String useCaseId, boolean withLog) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        VerifyUserAuthorizationInUseCaseCommand cmd = ICommandIdentifier.getInstance().getVerifyUserAuthorizationInUseCaseCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setUseCaseIdArg(useCaseId);
        cmd.setWithLogArg(withLog);
        return (Boolean)cmd.execute();
    }

    public boolean isAuthorized(User user, UseCase useCase) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)useCase);
        return this.isAuthorized(user.getLogin(), useCase.getId());
    }

    public boolean isAuthorized(User user, UseCase useCase, boolean withLog) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)useCase);
        return this.isAuthorized(user.getLogin(), useCase.getId(), withLog);
    }
}

