/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.userinformationvalue.FindAllUserInfoValueAuthorizationWithInfoValueCommand;
import br.com.petrobras.security.command.management.authorization.userinformationvalue.FindAllUserInfoValueAuthorizationWithUserCommand;
import br.com.petrobras.security.command.management.authorization.userinformationvalue.GrantInformationValueAuthorizationToUserCommand;
import br.com.petrobras.security.command.management.authorization.userinformationvalue.GrantSharedInformationValueAuthorizationToUserCommand;
import br.com.petrobras.security.command.management.authorization.userinformationvalue.RevokeInformationValueAuthorizationFromUserCommand;
import br.com.petrobras.security.command.management.authorization.userinformationvalue.RevokeSharedInformationValueAuthorizationFromUserCommand;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IUserInformationValueAuthorizationManager;
import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.Regional;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.model.authorization.information.UserInformationValueAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class UserInformationValueAuthorizationManagerCoreImpl
implements IUserInformationValueAuthorizationManager {
    private IUserContextIdentifier userContextIdentifier;

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public List<UserInformationValueAuthorization> findAllWithCurrentUser() throws PermissionDeniedException, InvalidOperationException, SecurityException {
        return this.findAllWithUser(this.getUserContextIdentifier().getCurrentUserContext().getLoggedUser().getLogin());
    }

    public List<UserInformationValueAuthorization> findAllWithUser(User user) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        return this.findAllWithUser(user.getLogin());
    }

    public List<UserInformationValueAuthorization> findAllWithUser(String userLogin) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllUserInfoValueAuthorizationWithUserCommand cmd = ICommandIdentifier.getInstance().getFindAllUserInfoValueAuthorizationWithUserCommand();
        cmd.setUserLoginArg(userLogin);
        return (List)cmd.execute();
    }

    public List<UserInformationValueAuthorization> findAllWithInformationValue(InformationValue informationValue) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            return this.findAllWithInformationValue(informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        }
        return this.findAllWithInformationValue(informationValue.getInformation().getId(), informationValue.getId());
    }

    public List<UserInformationValueAuthorization> findAllWithInformationValue(String informationId, String informationValueId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllUserInfoValueAuthorizationWithInfoValueCommand cmd = ICommandIdentifier.getInstance().getFindAllUserInfoValueAuthorizationWithInfoValueCommand();
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        return (List)cmd.execute();
    }

    public void grant(User user, InformationValue informationValue) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            this.grant(user.getLogin(), informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        } else {
            this.grant(user.getLogin(), informationValue.getInformation().getId(), informationValue.getId());
        }
    }

    public void grant(String userLogin, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantInformationValueAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getGrantInformationValueAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void grant(String userLogin, String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantSharedInformationValueAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getGrantSharedInformationValueAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void revoke(User user, InformationValue informationValue) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            this.revoke(user.getLogin(), informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        } else {
            this.revoke(user.getLogin(), informationValue.getInformation().getId(), informationValue.getId());
        }
    }

    public void revoke(String userLogin, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeInformationValueAuthorizationFromUserCommand cmd = ICommandIdentifier.getInstance().getRevokeInformationValueAuthorizationFromUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void revoke(String userLogin, String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeSharedInformationValueAuthorizationFromUserCommand cmd = ICommandIdentifier.getInstance().getRevokeSharedInformationValueAuthorizationFromUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public List<UserInformationValueAuthorization> findAllWithInformationValue(String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllUserInfoValueAuthorizationWithInfoValueCommand cmd = ICommandIdentifier.getInstance().getFindAllUserInfoValueAuthorizationWithInfoValueCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        return (List)cmd.execute();
    }
}

