/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.configuration;

import br.com.petrobras.security.configuration.SecurityConfigurer;
import br.com.petrobras.security.exception.ConfigurationException;
import br.com.petrobras.security.utility.StringUtil;
import br.com.petrobras.security.utility.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.jar.Manifest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuritySettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecuritySettings.class);
    private static final String COOKIE_VERIFICATION_SERVLET_PATH = "SingleSignOnCookieVerification.svlt";
    private static final String AUTHENTICATION_HANDLER_SERVLET_PATH = "AuthenticationHandler.svlt";
    private static final String DEFAULT_CONFIG_LOCATION = "config/fwca.properties";
    private static final String PROPERTIES_EXTENSION = ".properties";
    public static final String REGIONAL_ID_KEY = "regional_id";
    public static final String ENVIRONMENT_ID_KEY = "environment_id";
    public static final String APP_CATALOG_ID_KEY = "application_catalog_id";
    public static final String APP_PASSWORD_ID_KEY = "application_password";
    public static final String ENDPOINT_WSDL_KEY = "endpoint_wsdl";
    public static final String LOGON_PAGE_KEY = "logon_page";
    public static final String AJAX_URL_PATTERN_KEY = "ajax_url_pattern";
    public static final String SSO_ENABLED_KEY = "sso_enabled";
    public static final String INTEGRATED_AUTHENTICATION_ENABLED_KEY = "integrated_authentication_enabled";
    public static final String AFTER_LOGON_PAGE_KEY = "after_logon_page";
    public static final String APPLICATION_USER = "application_user";
    public static final String APPLICATION_USER_PASSWORD = "application_user_password";
    public static final String EXECUTION_TECHONOGY_CODE = "JAVA";
    private static String regionalId;
    private static String environmentId;
    private static String applicationCatalogId;
    private static String applicationPassword;
    private static String endpointWsdl;
    private static String logonPage;
    private static String ajaxUrlPattern;
    private static String globalCookieVerificationUrl;
    private static String afterLogonPage;
    private static String applicationUser;
    private static String applicationUserPassword;
    private static String executionVersion;
    private static String executionTechnology;
    private static boolean ssoEnabled;
    private static boolean integratedAuthenticationEnabled;
    private static boolean savedLog;

    public static void load(SecurityConfigurer securityConfigurer, String configLocation, boolean testConnection) {
        LOGGER.info("Carregando configura\u00e7\u00f5es de seguran\u00e7a do FWCA.");
        if (configLocation == null) {
            configLocation = DEFAULT_CONFIG_LOCATION;
        } else if (!configLocation.endsWith(PROPERTIES_EXTENSION)) {
            configLocation = configLocation + PROPERTIES_EXTENSION;
        }
        InputStream is = SecuritySettings.class.getClassLoader().getResourceAsStream(configLocation);
        if (is == null) {
            throw new ConfigurationException("Ocorreu um erro durante o carregamento das configura\u00e7\u00f5es de seguran\u00e7a do Framework de Controle de Acesso. O arquivo '" + configLocation + "' n\u00e3o foi encontrado.");
        }
        Properties props = new Properties();
        try {
            props.load(is);
            is.close();
            SecuritySettings.load(securityConfigurer, props, testConnection);
        }
        catch (IOException ioe) {
            LOGGER.warn("Erro", (Throwable)ioe);
        }
    }

    public static void load(SecurityConfigurer securityConfigurer, Properties properties, boolean testConnection) {
        regionalId = SecuritySettings.getValue(properties, REGIONAL_ID_KEY, false);
        environmentId = SecuritySettings.getValue(properties, ENVIRONMENT_ID_KEY, false);
        applicationCatalogId = SecuritySettings.getValue(properties, APP_CATALOG_ID_KEY, false);
        applicationPassword = SecuritySettings.getValue(properties, APP_PASSWORD_ID_KEY, false);
        endpointWsdl = SecuritySettings.getValue(properties, ENDPOINT_WSDL_KEY, false);
        logonPage = SecuritySettings.getValue(properties, LOGON_PAGE_KEY, true);
        ajaxUrlPattern = SecuritySettings.getValue(properties, AJAX_URL_PATTERN_KEY, true);
        ssoEnabled = Boolean.parseBoolean(SecuritySettings.getValue(properties, SSO_ENABLED_KEY, true));
        integratedAuthenticationEnabled = Boolean.parseBoolean(SecuritySettings.getValue(properties, INTEGRATED_AUTHENTICATION_ENABLED_KEY, true));
        afterLogonPage = SecuritySettings.getValue(properties, AFTER_LOGON_PAGE_KEY, true);
        applicationUser = SecuritySettings.getValue(properties, APPLICATION_USER, true);
        applicationUserPassword = SecuritySettings.getValue(properties, APPLICATION_USER_PASSWORD, true);
        globalCookieVerificationUrl = SecuritySettings.getGlobalCookieVerificationUrl();
        executionTechnology = EXECUTION_TECHONOGY_CODE;
        SecuritySettings.loadManifestData();
        securityConfigurer.configure(testConnection);
    }

    private static String getValue(Properties props, String key, boolean optional) {
        String value;
        block4: {
            value = null;
            try {
                value = (String)props.get(key);
            }
            catch (MissingResourceException mre) {
                if (optional) break block4;
                throw new IllegalArgumentException("A propriedade [{} " + key + " ] n\u00e3o foi encontrada no arquivo de configura\u00e7\u00e3o do FWCA", mre);
            }
        }
        LOGGER.debug("Chave [{}] = {}", (Object)(key.toLowerCase().contains("password") ? key.concat("-MD5-hash") : key), (Object)(key.toLowerCase().contains("password") ? (value != null ? SecuritySettings.md5sum(value) : null) : value));
        if (!optional && Validator.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("A propriedade [ " + key + " ] do arquivo de configura\u00e7\u00e3o do FWCA n\u00e3o pode ser nula ou vazia.");
        }
        if (value != null) {
            return value.trim();
        }
        return null;
    }

    private static String md5sum(String value) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algoritmo MD5 indispon\u00edvel.", e);
        }
        md.update(value.getBytes());
        byte[] digest = md.digest();
        return DatatypeConverter.printHexBinary((byte[])digest);
    }

    public static String getRegionalId() {
        return regionalId;
    }

    public static String getEnvironmentId() {
        return environmentId;
    }

    public static String getApplicationCatalogId() {
        return applicationCatalogId;
    }

    public static String getApplicationPassword() {
        return applicationPassword;
    }

    public static String getEndpointWsdl() {
        return endpointWsdl;
    }

    public static String getLogonPage(HttpServletRequest request) {
        if (!StringUtil.isNullOrEmpty((String)logonPage)) {
            String logonPageURL = logonPage;
            if (!logonPageURL.startsWith("/")) {
                logonPageURL = logonPageURL + "/";
            }
            return SecuritySettings.getBaseUrl(request) + logonPageURL;
        }
        return null;
    }

    public static String getAfterLogonPage() {
        return afterLogonPage;
    }

    public static String getApplicationUser() {
        return applicationUser;
    }

    public static String getApplicationUserPassword() {
        return applicationUserPassword;
    }

    public static String getAjaxUrlPattern() {
        return ajaxUrlPattern;
    }

    public static boolean isSSOEnabled() {
        return ssoEnabled;
    }

    public static boolean isIntegratedAuthenticationEnabled() {
        return integratedAuthenticationEnabled;
    }

    public static String getGlobalCookieVerificationUrl() {
        if (globalCookieVerificationUrl == null) {
            String urlBase = SecuritySettings.getServiceBaseUrl();
            globalCookieVerificationUrl = urlBase + COOKIE_VERIFICATION_SERVLET_PATH;
        }
        return globalCookieVerificationUrl;
    }

    public static String getExecutionVersion() {
        return executionVersion;
    }

    public static String getExecutionTechnology() {
        return executionTechnology;
    }

    private static String getServiceBaseUrl() {
        String urlEndPoint = SecuritySettings.getEndpointWsdl();
        int pos = urlEndPoint.indexOf("/fwca/");
        String urlBase = urlEndPoint.substring(0, pos + "/fwca/".length());
        return urlBase;
    }

    private static final String getBaseUrl(HttpServletRequest httpRequest) {
        String protocol = "";
        String server = httpRequest.getServerName();
        String port = Integer.toString(httpRequest.getServerPort());
        String context = httpRequest.getContextPath();
        protocol = httpRequest.isSecure() ? "https" : "http";
        StringBuilder baseUrl = new StringBuilder(protocol).append("://").append(server).append(":").append(port).append(context);
        return baseUrl.toString();
    }

    private static void loadManifestData() {
        try {
            Enumeration<URL> list = SecuritySettings.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (list.hasMoreElements()) {
                URL url = list.nextElement();
                InputStream is = url.openStream();
                Manifest mf = new Manifest(is);
                if (is != null) {
                    is.close();
                }
                if (!"br.com.petrobras.security".equalsIgnoreCase(mf.getMainAttributes().getValue("Implementation-Vendor-Id"))) continue;
                executionVersion = mf.getMainAttributes().getValue("Implementation-Version");
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean getSavedLog() {
        return savedLog;
    }

    public static void setSavedLog(boolean savedLog) {
        SecuritySettings.savedLog = savedLog;
    }

    static {
        executionVersion = "<versaoAPI>";
        ssoEnabled = false;
        integratedAuthenticationEnabled = false;
        savedLog = false;
    }
}

