/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.context;

import br.com.petrobras.security.context.state.ApplicationEnvironmentContextState;
import br.com.petrobras.security.context.state.UserContextState;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.model.security.TokenUser;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserContext
implements Serializable {
    private static final long serialVersionUID = -2503457412109039285L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserContext.class);
    private UserContextState state = UserContextState.NOT_LOGGED;
    private Boolean integratedAuthenticationInUse = null;
    private ApplicationEnvironmentContextState applicationEnvironmentContextState = ApplicationEnvironmentContextState.DISCONNECTED;
    private TokenUser tokenUser = new TokenUser();
    private Locale preferredUserLanguage;

    public UserContextState getState() {
        return this.state;
    }

    public void setState(UserContextState state) {
        this.state = state;
    }

    public TokenUser getTokenUser() {
        return this.tokenUser;
    }

    public void setTokenUser(TokenUser tokenUser) {
        this.tokenUser = tokenUser;
    }

    public User getLoggedUser() throws RuntimeException {
        if (this.getState() == UserContextState.LOGGED) {
            return this.getTokenUser().getUser();
        }
        return null;
    }

    public Locale getPreferredUserLanguage() {
        if (this.preferredUserLanguage != null) {
            return this.preferredUserLanguage;
        }
        return this.getLoggedUser().getPreferredLanguage();
    }

    public String getGlobalSessionId() {
        if (this.getTokenUser() != null && this.getTokenUser().getTicket() != null) {
            return this.getTokenUser().getTicket().getGlobalSessionId();
        }
        return null;
    }

    public void setGlobalSessionId(String globalSessionId) {
        if (this.getTokenUser() != null && this.getTokenUser().getTicket() != null) {
            this.getTokenUser().getTicket().setGlobalSessionId(globalSessionId);
        }
    }

    public void setPreferredUserLanguage(Locale preferredUserLanguage) {
        this.preferredUserLanguage = preferredUserLanguage;
    }

    public ApplicationEnvironmentContextState getApplicationEnvironmentContextState() {
        return this.applicationEnvironmentContextState;
    }

    public void setApplicationEnvironmentContextState(ApplicationEnvironmentContextState applicationEnvironmentContextState) {
        this.applicationEnvironmentContextState = applicationEnvironmentContextState;
    }

    public ApplicationEnvironment getConnectedApplicationEnvironment() {
        return this.getTokenUser().getApplicationEnvironment();
    }

    public List<SupportedLanguage> getSupportedApplicationLanguages() {
        return this.getTokenUser().getSupportedLanguages();
    }

    public Boolean isIntegratedAuthenticationInUse() {
        return this.integratedAuthenticationInUse;
    }

    public void logoff() {
        LOGGER.info("Realizando logoff do usu\u00e1rio.");
        this.setState(UserContextState.NOT_LOGGED);
        this.disconnect();
        this.setTokenUser(new TokenUser());
        this.setGlobalSessionId(null);
        this.integratedAuthenticationInUse = false;
        LOGGER.info("Logoff do usu\u00e1rio realizado com sucesso.");
    }

    public void disconnect() {
        this.setApplicationEnvironmentContextState(ApplicationEnvironmentContextState.DISCONNECTED);
    }
}

