/*
 * ResourceAuthorizerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.authorization.IResourceAuthorizerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ContextValueSetMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.model.authorization.access.map.ResourceAuthorizationMapItem;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.ContextValueSetDTO;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Implementao "SOAP" de um consumidor de autorizador em recurso.
 *
 */
public class ResourceAuthorizerConsumerSoapImpl
implements
    IResourceAuthorizerConsumer,
    Serializable {

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 8595558816686297382L;

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;


    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /**
     * {@inheritDoc}
     */
    public ReturnMessage<List<Resource>> findAll(MessageHeader messageHeader, String userLogin, ContextValueSet contextValuesSet, boolean considerContext) {

        SoapMessageHeader soapMessageHeader = MessageHeaderMounter.mountTransferObject(messageHeader);

        List<SupportedLanguage> supportedLanguages = this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages();

        ContextValueSetDTO contexts = ContextValueSetMounter.mountTransferObject(contextValuesSet, supportedLanguages);

        SoapReturnMessageWithListValue soapReturnMessageWithListValue = ConsumeSoapUtil.getCurrentEndPoint().findAllResourcesAuthorizedToUserInContext(soapMessageHeader, userLogin, contexts, considerContext);

        return ReturnMessageMounter.mountLocalObjectWithResourceListValue(
                soapReturnMessageWithListValue,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                supportedLanguages);

    }

    /**
     * {@inheritDoc}
     */
    public ReturnMessage<List<Resource>> findAllIgnoreManagerPrivilege(MessageHeader messageHeader, String userLogin) {

        SoapMessageHeader soapMessageHeader = MessageHeaderMounter.mountTransferObject(messageHeader);

        List<SupportedLanguage> supportedLanguages = this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages();

        SoapReturnMessageWithListValue soapReturnMessageWithListValue = ConsumeSoapUtil.getCurrentEndPoint().findAllResourcesAuthorizedIgnoreManagerPrivilege(soapMessageHeader, userLogin);

        return ReturnMessageMounter.mountLocalObjectWithResourceListValue(
                soapReturnMessageWithListValue,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                supportedLanguages);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.authorization.IResourceAuthorizerConsumer#getMap(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String)
     */
    public ReturnMessage<Map<String, ResourceAuthorizationMapItem>> getMap(MessageHeader messageHeader, String userLogin,  ContextValueSet contextValuesSet, boolean considerContext) {

        SoapMessageHeader soapMessageHeader = MessageHeaderMounter.mountTransferObject(messageHeader);

        List<SupportedLanguage> supportedLanguages = this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages();
        ContextValueSetDTO contexts = ContextValueSetMounter.mountTransferObject(contextValuesSet, supportedLanguages);

        SoapReturnMessageWithListValue soapReturnMessageWithListValue =
                ConsumeSoapUtil.getCurrentEndPoint().getResourceAuthorizationsMapOfUserInContext(soapMessageHeader, userLogin, contexts, considerContext);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithResourceAuthorizationsMapValue(
                soapReturnMessageWithListValue,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                supportedLanguages);
    }

	public ReturnMessage<Map<String, ResourceAuthorizationMapItem>> getMapOfRole(MessageHeader messageHeader, String roleId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().getResourceAuthorizationsMapOfRole(smhDTO, roleId);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithResourceAuthorizationsMapValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
	}

    @Override
    public ReturnMessage<List<Resource>> findAllInApplication(MessageHeader messageHeader, String userLogin) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader soapMessageHeader = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue soapReturnMessageWithListValue = ConsumeSoapUtil.getCurrentEndPoint().findAllResourcesAuthorizedToUserInApplication(soapMessageHeader, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithResourceListValue(
                soapReturnMessageWithListValue, this.getUserContextIdentifier().getCurrentUserContext()
                .getPreferredUserLanguage(), this
                .getUserContextIdentifier().getCurrentUserContext()
                .getSupportedApplicationLanguages());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ReturnMessage<Boolean> isAuthorizedToUserInContext(MessageHeader messageHeader, String resourceId, String userLogin, ContextValueSet contextValuesSet, boolean considerContext) {

        List<SupportedLanguage> supportedLanguages = this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages();
        ContextValueSetDTO contexts = ContextValueSetMounter.mountTransferObject(contextValuesSet, supportedLanguages);

        SoapMessageHeader soapMessageHeader = MessageHeaderMounter.mountTransferObject(messageHeader);

        SoapReturnMessage soapReturnMessage = ConsumeSoapUtil.getCurrentEndPoint()
                .isResourceAuthorizedToUserInContext(
                        soapMessageHeader, resourceId, userLogin, contexts, considerContext);

        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(soapReturnMessage);
    }

}

