/*
 * InformationSharingAuthorizationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IInformationSharingAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Implementao "SOAP" de consumidor de gerenciador de autorizaes em uma informao com o tipo de compartilhamento por sistema para um outro sistema.
 * 
 * @author Eraldo Neto - HMGL
 *
 */
public class InformationSharingAuthorizationManagerConsumerSoapImpl implements
        IInformationSharingAuthorizationManagerConsumer {

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */
    
    /* [ Operators ] */
      
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IInformationSharingAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> grant(MessageHeader mh,
            String regionalId, String applicationCatalogId, String informationId)
            throws ObjectNotFoundException {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantInformationSharingToAppEnv(smhDTO, regionalId, applicationCatalogId, informationId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IInformationSharingAuthorizationManagerConsumer#revoke(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader mh, String regionalId, String applicationCatalogId, String informationId)
            throws ObjectNotFoundException {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeInformationSharingFromAppEnv(smhDTO, regionalId, applicationCatalogId, informationId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

    }

    public ReturnMessage<List<Application>> findAllApplicationsWithSharingAuthorizationInInformation(MessageHeader mh, String regionalId, String informationId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findAllApplicationsWithSharingAuthorizationInInformation(smhDTO, regionalId, informationId);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithApplicationListValue
            (rmDTO, this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage());
        
    }
    
    /* [ Operators ] */

}
