package csbase.rest.adapter.algorithm.v1;

import java.util.stream.Collectors;

import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.SimpleParameter;
import ibase.rest.model.algorithm.v1.Parameter;

/**
 * Created by mjulia on 10/06/16.
 */
public class EnumerationParameterFactory implements  ParameterFactory {

    public ibase.rest.model.algorithm.v1.Parameter buildParameter(SimpleParameter p) {
        ibase.rest.model.algorithm.v1.EnumerationParameter parameter =
                new ibase.rest.model.algorithm.v1.EnumerationParameter();
        setCommonAttributes(parameter, p);
        parameter.setType(Parameter.TypeEnum.ENUMERATION);
        if (csbase.logic.algorithms.parameters.EnumerationListParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.EnumerationListParameter csbaseParam =
                    csbase.logic.algorithms.parameters.EnumerationListParameter.class.cast(p);
            parameter.setItems(csbaseParam.getItems().stream().map(i -> buildEnumItem(i)).
                    collect(Collectors.toList()));
            parameter.setMultipleSelection(true);
            parameter.setSort(csbaseParam.mustSort());
        }
        else if (csbase.logic.algorithms.parameters.EnumerationParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.EnumerationParameter csbaseParam =
                    csbase.logic.algorithms.parameters.EnumerationParameter.class.cast(p);
            parameter.setItems(csbaseParam.getItems().stream().map(i -> buildEnumItem(i)).
                    collect(Collectors.toList()));
            parameter.setMultipleSelection(false);
        }
        return parameter;
    }
    private ibase.rest.model.algorithm.v1.EnumerationItem buildEnumItem(EnumerationItem i) {
        ibase.rest.model.algorithm.v1.EnumerationItem item = new ibase.rest.model.algorithm.v1.EnumerationItem();
        item.setId(i.getId());
        item.setLabel(i.getLabel());
        item.setValue(i.getValue());
        return item;
    }
    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.ENUMERATION;
    }

}
