/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.rest.adapter.algorithm.v1.ParameterFactory;
import ibase.rest.model.algorithm.v2.EnumerationItem;
import ibase.rest.model.algorithm.v2.Parameter;
import ibase.rest.model.algorithm.v2.ParameterType;
import java.util.stream.Collectors;

public class EnumerationParameterFactory
implements ParameterFactory {
    @Override
    public Parameter buildParameter(SimpleParameter<?> p) {
        ibase.rest.model.algorithm.v2.EnumerationParameter parameter = new ibase.rest.model.algorithm.v2.EnumerationParameter();
        this.setCommonAttributes((Parameter)parameter, p);
        parameter.setType(this.getType());
        if (p instanceof EnumerationListParameter) {
            EnumerationListParameter csbaseParam = (EnumerationListParameter)p;
            parameter.setItems(csbaseParam.getItems().stream().map(this::buildEnumItem).collect(Collectors.toList()));
            parameter.setMultipleSelection(Boolean.valueOf(true));
            parameter.setSort(Boolean.valueOf(csbaseParam.mustSort()));
        } else if (p instanceof EnumerationParameter) {
            EnumerationParameter csbaseParam = (EnumerationParameter)p;
            parameter.setItems(csbaseParam.getItems().stream().map(this::buildEnumItem).collect(Collectors.toList()));
            parameter.setMultipleSelection(Boolean.valueOf(false));
        }
        return parameter;
    }

    private EnumerationItem buildEnumItem(csbase.logic.algorithms.parameters.EnumerationItem i) {
        EnumerationItem item = new EnumerationItem();
        item.setId(i.getId());
        item.setLabel(i.getLabel());
        item.setValue(i.getValue());
        item.setDescription(i.getDescription());
        return item;
    }

    @Override
    public String getType() {
        return ParameterType.ENUMERATION.toString();
    }
}

