/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.rest.adapter.algorithm.v1.ParameterFactory;
import ibase.rest.model.algorithm.v2.InputURLParameter;
import ibase.rest.model.algorithm.v2.Parameter;
import ibase.rest.model.algorithm.v2.ParameterType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;

public class InputURLParameterFactory
implements ParameterFactory {
    @Override
    public Parameter buildParameter(SimpleParameter<?> p) {
        InputURLParameter parameter = new InputURLParameter();
        this.setCommonAttributes((Parameter)parameter, p);
        parameter.setType(this.getType());
        if (p instanceof InputURLListParameter) {
            InputURLListParameter csbaseParam = (InputURLListParameter)p;
            parameter.setMultipleSelection(Boolean.valueOf(true));
            parameter.setSort(Boolean.valueOf(csbaseParam.mustSort()));
            this.setMode(csbaseParam.getMode(), parameter);
            this.setProtocol(csbaseParam.getAllowedProtocols(), parameter);
            parameter.setAllowsPipe(InputURLParameter.AllowsPipeEnum.FALSE);
        } else if (p instanceof csbase.logic.algorithms.parameters.InputURLParameter) {
            csbase.logic.algorithms.parameters.InputURLParameter csbaseParam = (csbase.logic.algorithms.parameters.InputURLParameter)p;
            parameter.setMultipleSelection(Boolean.valueOf(false));
            parameter.setSort(Boolean.valueOf(false));
            this.setAllowsPipe(csbaseParam.usesPipe(), parameter);
            if (csbaseParam.usesPipe().equals((Object)FileParameterPipeAcceptance.ALWAYS)) {
                parameter.setHidden(Boolean.valueOf(true));
            }
            this.setMode(csbaseParam.getMode(), parameter);
            this.setProtocol(csbaseParam.getAllowedProtocols(), parameter);
        }
        return parameter;
    }

    private void setAllowsPipe(FileParameterPipeAcceptance allowsPipe, InputURLParameter parameter) {
        switch (allowsPipe) {
            case TRUE: {
                parameter.setAllowsPipe(InputURLParameter.AllowsPipeEnum.TRUE);
                break;
            }
            case FALSE: {
                parameter.setAllowsPipe(InputURLParameter.AllowsPipeEnum.FALSE);
                break;
            }
            case ALWAYS: {
                parameter.setAllowsPipe(InputURLParameter.AllowsPipeEnum.ALWAYS);
            }
        }
    }

    private void setMode(FileParameterMode mode, InputURLParameter parameter) {
        switch (mode) {
            case REGULAR_FILE: {
                parameter.setCategory(InputURLParameter.CategoryEnum.REGULAR);
                break;
            }
            case DIRECTORY: {
                parameter.setCategory(InputURLParameter.CategoryEnum.FOLDER);
            }
        }
    }

    private void setProtocol(EnumSet<URLProtocol> allowedProtocols, InputURLParameter parameter) {
        HashSet<InputURLParameter.ProtocolEnum> protocols = new HashSet<InputURLParameter.ProtocolEnum>();
        for (URLProtocol protocol : allowedProtocols) {
            switch (protocol) {
                case PROJECT: {
                    protocols.add(InputURLParameter.ProtocolEnum.PROJECT);
                    break;
                }
                case SGA: 
                case LOCAL: {
                    protocols.add(InputURLParameter.ProtocolEnum.LOCAL);
                }
            }
        }
        parameter.setProtocol(new ArrayList(protocols));
    }

    @Override
    public String getType() {
        return ParameterType.INPUT_URL.toString();
    }
}

