package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.SimpleParameter;
import ibase.rest.model.algorithm.v1.Parameter;

/**
 * Created by mjulia on 10/06/16.
 */
public class IntegerParameterFactory implements  ParameterFactory {

    public ibase.rest.model.algorithm.v1.Parameter buildParameter(SimpleParameter p) {
        ibase.rest.model.algorithm.v1.IntegerParameter parameter =
                new ibase.rest.model.algorithm.v1.IntegerParameter();
        setCommonAttributes(parameter, p);
        parameter.setType(Parameter.TypeEnum.INTEGER);
        if (csbase.logic.algorithms.parameters.IntegerParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.IntegerParameter csbaseParam =
                    csbase.logic.algorithms.parameters.IntegerParameter.class.cast(p);
            parameter.setMultipleSelection(false);
            parameter.setMaximum(csbaseParam.getMaximum());
            parameter.setMinimum(csbaseParam.getMinimum());
        } else if (csbase.logic.algorithms.parameters.IntegerListParameter.class.isInstance(p)) {
            parameter.setMultipleSelection(true);
            csbase.logic.algorithms.parameters.IntegerListParameter csbaseParam =
                    csbase.logic.algorithms.parameters.IntegerListParameter.class.cast(p);
            parameter.setMaximum(csbaseParam.getMaximum());
            parameter.setMinimum(csbaseParam.getMinimum());
        }
        return parameter;
    }
    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.INTEGER;
    }

}
