package csbase.rest.adapter.algorithm.v1;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by mjulia on 10/06/16.
 */
public class ParameterMapper {

    private Map<String, ParameterFactory> map;

    public ParameterMapper() {
        load();
    }

    private  void load() {
        this.map = new HashMap<>();
        map.put(csbase.logic.algorithms.parameters.IntegerParameter.TYPE,
                new IntegerParameterFactory());
        map.put(csbase.logic.algorithms.parameters.IntegerListParameter.TYPE,
                new IntegerParameterFactory());
        map.put(csbase.logic.algorithms.parameters.BooleanParameter.TYPE,
                new BooleanParameterFactory());
        map.put(csbase.logic.algorithms.parameters.DoubleParameter.TYPE,
                new DoubleParameterFactory());
        map.put(csbase.logic.algorithms.parameters.DoubleListParameter.TYPE,
                new DoubleParameterFactory());
        map.put(csbase.logic.algorithms.parameters.TextParameter.TYPE,
                new StringParameterFactory());
        map.put(csbase.logic.algorithms.parameters.TextListParameter.TYPE,
                new StringParameterFactory());
        map.put(csbase.logic.algorithms.parameters.InputFileParameter.TYPE,
                new InputFileParameterFactory());
        map.put(csbase.logic.algorithms.parameters.InputFileListParameter.TYPE,
                new InputFileParameterFactory());
        map.put(csbase.logic.algorithms.parameters.OutputFileParameter.TYPE,
                new OutputFileParameterFactory());
        map.put(csbase.logic.algorithms.parameters.OutputFileListParameter.TYPE,
                new OutputFileParameterFactory());
        map.put(csbase.logic.algorithms.parameters.EnumerationListParameter.TYPE,
                new EnumerationParameterFactory());
        map.put(csbase.logic.algorithms.parameters.EnumerationParameter.TYPE,
                new EnumerationParameterFactory());
    }

    public ParameterFactory getFactoryFor (String type) {
        //System.out.println("Type =" + type);
        ParameterFactory factory = map.get(type);
        if (factory==null) {
            factory = new UnsupportedParameterFactory();
        }
        return factory;
    }
}
